/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.CardRuntimeException;

/**
 * The <code>HCIException</code> class encapsulates specific exceptions allows
 * the classes of this package to throw specific exceptions in case of problems.
 **/
public class HCIException extends CardRuntimeException {

    // ---------  Reasons value -------------
    /** The HCI protocol is not available. */
    public final static short HCI_NOT_AVAILABLE = (short)0; 
    /** The Applet is not granted access to this HCI resource*/
    public final static short HCI_ACCESS_NOT_GRANTED = (short)1;
    /** The requested Service (CardEmulation, ReaderMode, Connectivity) is not avilable */
    public final static short HCI_SERVICE_NOT_AVAILABLE = (short)2;
    /** The interface to the contactless frontend (CLF) is currently disabled */
    public final static short HCI_CURRENTLY_DISABLED = (short)3;
    /** Indicates  that a wrong Listener type is registered to a Service */
    public final static short HCI_WRONG_LISTENER_TYPE = (short)4;
    /** Indicates  that an Applet instance has already registered a Listener of this type */
    public final static short HCI_LISTENER_ALREADY_REGISTERED = (short)5;
    /** Indicates  that a wrong event type is activated for this Service */
    public final static short HCI_WRONG_EVENT_TYPE = (short)6;
    /** Indicates that an attempt is made to send an HCIMessage to the CLF while
     *  receiving a fragmented HCIMessage is still ongoing */
    public final static short HCI_FRAGMENTED_MESSAGE_ONGOING = (short)7;
    /** Indicates that the contactless framework has not enough resources to fulfill
     * the command */
    public final static short HCI_RESOURCES_NOT_AVAILABLE = (short)8;
    /** Indicates that a parameter has not the correct length */
    public static final short HCI_INVALID_LENGTH = (short)9;
    /** Indicates that the conditions to register a specific event or to call a specific method are not fulfilled */
    public static final short HCI_CONDITIONS_NOT_SATISFIED = (short)10;
    /** Indicates a wrong parameter value */
    public static final short HCI_WRONG_PARAMETER_VALUE = (short)11;
    
    /**
     * Constructs a HCIException with the specified reason. To conserve on resources use
     * <code>throwIt()</code> to use the JCRE instance of this class.
     *
     * @param  reason the reason for the exception
     */
    public HCIException(short reason) {
        super(reason);
    }

    /**
     * Throws the JCRE owned instance of the <code>HCIException</code> with the specified
     * reason code.
     * 
     * @param reason the reason for the exception.
     * @exception HCIException the JCRE owned instance of the HCIException
     */
    public static void throwIt(short reason) throws HCIException {
    }
}

