/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.Shareable;

/** The base interface for all types of HCI listeners.
 * <P>
 * An Object shall not implement this interface but only implement one of the sub-interfaces.
 * 
 * <P>
 * An Applet instance implementing a <code>*Listener</code> interface shall only 
 * receive events defined in the same <code>*Listener</code> interface or in the
 * <code>HCIListner</code> interface.
 * <p>
 * If a Class is implementing more then one <code>HCIListener</code> sub-interfaces
 * the Applet should check the type of the <code>HCIMesage</code> by using
 * <code>instanceof</code> in order to identify the source of the notification.
 * </p>
 * <P>
 * Messages received through the inherited method <code>HCIListener.onCallback</code>
 * shall be of the message type defined in the same package as the <code>*Listener</code> interface
 * <P>
 *
 * @see uicc.hci.services.cardemulation.CardEmulationListener
 * @see uicc.hci.services.connectivity.ConnectivityListener
 * @see uicc.hci.services.readermode.ReaderListener
 **/
public interface HCIListener extends Shareable {

    /**
     * This value is used to notify the Applet when the UICC failed to transmit a message to the CLF.
     * 
     * The Applet has to activate this event (for a specific service) if it wants to be notified
     * about data transmission errors (that occur for a specific service):
     */
    public final static byte EVENT_HCI_TRANSMISSION_FAILED = (byte) 0x81;

    /**
     * This value is used to notify the Applet when the UICC failed to receive a message sent by the CLF.
     * 
     * The Applet has to activate this event (for a specific service) if it wants to be notified
     * about data transmission errors (that occur for a specific service):
     */
    public final static byte EVENT_HCI_RECEPTION_FAILED = (byte) 0x82;



    /** This method is called by the HCI framework to inform the Listener
     *  Object about a specific event and pass the corresponding <code>HCIMessage</code> to
     *  the Listener Object.
     *
     * In the case of an <code>EVENT_HCI_TRANSMISSION_FAILED</code> the message
     * which could not be transmitted shall be made available in the <code>HCIMessage</code> object.
     *
     * If an Applet has requested the framework to send more than one message during a single
     * <code>onCallback</code> method execution and a transmission to the CLF failed the framework
     * shall not attempt to send any of the remaining messages.
     *
     * The <code>EVENT_HCI_RECEPTION_FAILED</code> shall not be raised in the case of a
     * failure to receive a command from an external reader in CardEmulation Mode due to a problem
     * on the data link layer
     * 
     * @param  event that triggers the invocation of the method
     * @param  message the HCIMessage
     */
    public void onCallback(byte event, HCIMessage message);
}
