/*
 * %W% %E%
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javasoft.sqe.jc_tck_internal;

import java.util.Set;
import com.sun.javatest.lib.StdTestScript;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.jck.lib.JCKScript;

public class PrecompileScript extends JCKScript {

    /**
     * This scripts overrides developer mode only. In this mode, the
     * test fails if the precompilation or execution have been failed,
     * even if this test is runtime and negative. This script is used
     * for cap file creation.
     */
    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        boolean isDeveloperMode = false;
        String precompileArgs[] = new String[args.length];
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-developer")) {
                isDeveloperMode = true;
                precompileArgs[i] = "-precompile";
            } else {
                precompileArgs[i] = args[i];
            }
        }
        negativeKey = td.getKeywordTable().contains("negative");
        
        // precompile the test
        Status precompile = super.run(precompileArgs, td, env);
        if (!precompile.isPassed() || !isDeveloperMode || negativeKey)
            return precompile;

	    // Exercise the test component...
	    trOut.println("Executing test class by PrecompileScript...");
	    return execute(TEST_EXECUTE, td.getParameter("executeClass"),
                       td.getParameter("executeArgs"));
	}

    private static final String TEST_EXECUTE = "testExecute";

    // Keys are set from test description keywords
    //
    protected boolean negativeKey;
}
