/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.me.tools.fs;

import com.sun.tck.me.utils.Closable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public interface FileSystem extends Closable {
    public static enum FileType {
        DOES_NOT_EXIST,
        FILE,
        DIR,
        UNKNOWN
    };

    public static interface Filter {
        public boolean accept(FileSystem fs, String path);
        public boolean doLookInside(FileSystem fs, String path);
    }

    public static final Filter ALL = new Filter() {

        @Override
        public boolean accept(FileSystem fs, String path) {
            return true;
        }

        @Override
        public boolean doLookInside(FileSystem fs, String path) {
            return true;
        }

    };
    public InputStream openToRead(String path) throws IOException;
    public OutputStream openToWrite(String path) throws IOException;
    public FileType getType(String path);
    public String[] list(String path, Filter filter);
    public void switchTo(String path);
    public void close() throws IOException;
}
