/*
 * %W% %E%
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.ui;

import com.sun.tck.bvtool.terminal.StatefulCardTerminal;

/*
 * Interface for interaction with BVT's user
 *
 * @author Mikhail Smirnov
 */
public interface UserInteraction {
    
    /**
     * Shows "Insert card into a terminal dialog"
     * @param terminalLabel label of the terminal in which card should be inserted
     * @return StatefulCardTerminal instance corresponding to physical terminal where
     * card is inserted by user
     */
    public StatefulCardTerminal askForCardInsertion(String terminalLabel, boolean replacement);

    /**
     * Shows removal (if a card is present) and then insertion dialogs. This
     * method doesn't check if card that is inserted differs from card that was removed.
     *
     * @param terminal
     * @return true if card was replaced (removed and inserted).
     */
    public boolean askForCardReplacement(StatefulCardTerminal terminal);


    /**
     * Shows modal dialog that asks user to enter an ID of the inserted card
     */
    public String showCardIDSelectDialog(String terminalLabel);

    /**
     * Shows dialog that asks user whether to retry card insertion after
     * failed attempt to connect to the inserted card
     * @param terminalLabel
     * @return whether to retry insertion attempt
     */
    public boolean askForRetryAfterFailedConnection(String terminalLabel);
}
