/*
 * %W% %E%
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.gui;

import javax.swing.JDialog;
import javax.swing.JLabel;
import java.awt.Frame;
import javax.swing.GroupLayout;

import com.sun.javacard.cjck.I18n;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

import static javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE;
import static javax.swing.SwingConstants.CENTER;

/*
 * Dialog that asks user to insert a card into a terminal
 * indicated by label
 *
 * @author Mikhail Smirnov
 */
public class InsertCardDialog extends JDialog {


    private JLabel msgLabel;
    private JButton cancelButton;
    private boolean identificationCancelled = false;

    /** Creates new form InsertCardDialog */
    public InsertCardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {

        msgLabel = new JLabel();
        cancelButton = new JButton(I18n.getString("no.more.readers.needed"));
        cancelButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                identificationCancelled = true;
            }
        });
        int horSize = 600;
        int verSize = 80;
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setTitle(I18n.getString("insert.card"));
        setAlwaysOnTop(true);
        setIconImage(null);
        setIconImages(null);
        setModal(true);
        setResizable(false);
        setSize(horSize, verSize);
        setLocation(getToolkit().getScreenSize().width/2 - horSize/2,
                getToolkit().getScreenSize().height/2 - verSize/2);

        msgLabel.setHorizontalAlignment(CENTER);

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        /*layout.setHorizontalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 500, GroupLayout.PREFERRED_SIZE)
                .addContainerGap(60, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
                .addContainerGap(20, Short.MAX_VALUE))
        );*/

        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(30, 30, 30)
                        .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 300, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(40, 40, 40)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER, false)
                            .addComponent(msgLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 500, javax.swing.GroupLayout.PREFERRED_SIZE)
                            )))
                .addContainerGap(60, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
                .addGap(30, 30, 30)
                .addComponent(cancelButton)
                .addGap(25, 25, 25))
        );

        pack();
    }

    public void setTerminalName(String name) {
        msgLabel.setText(I18n.getString("insert.card.message", name));
        if ("1".equals(name)) {
            cancelButton.setVisible(false);
        } else {
            cancelButton.setVisible(true);
        }
    }

    public void setReplacement(boolean isReplacement) {
        if (isReplacement) {
            cancelButton.setVisible(true);
        }
    }

    public boolean isIdentificationCancelled() {
        return identificationCancelled;
    }
    

}
