/*
 * %W% %E%
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.gui;

import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import java.awt.Frame;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;

import com.sun.javacard.cjck.I18n;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.LayoutStyle.ComponentPlacement;

import static javax.swing.WindowConstants.DISPOSE_ON_CLOSE;
import static javax.swing.SwingConstants.CENTER;

/*
 * Dialog that asks user to insert a card into a terminal
 * indicated by label
 *
 * @author Mikhail Smirnov
 */
public class ExceptionDialog extends JDialog {

    private JLabel msgLabel;
    private boolean retryChosen = false;

    /** Creates new form InsertCardDialog */
    public ExceptionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {
        msgLabel = new JLabel();
        int horSize = 600;
        int verSize = 80;
        JButton retryButton = new JButton(I18n.getString("retry"));
        retryButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                retryChosen = true;
                setVisible(false);
                dispose();
            }
        });
        JButton cancelButton = new JButton(I18n.getString("cancel"));
        cancelButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                retryChosen = false;
                setVisible(false);
                dispose();
            }
        });

        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        setAlwaysOnTop(true);
        setIconImage(null);
        setIconImages(null);
        setModal(true);
        setResizable(false);
        setSize(horSize, verSize);
        setLocation(getToolkit().getScreenSize().width / 2 - horSize / 2,
                getToolkit().getScreenSize().height / 2 - verSize / 2);

        msgLabel.setHorizontalAlignment(CENTER);

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(34, 34, 34)
                        .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 493, GroupLayout.PREFERRED_SIZE))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(154, 154, 154)
                            .addComponent(retryButton)
                            .addGap(113, 113, 113)
                            .addComponent(cancelButton)
                        )
                )
                .addContainerGap(23, Short.MAX_VALUE)
            )
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
            .addGap(25, 25, 25)
            .addComponent(msgLabel)
            .addPreferredGap(ComponentPlacement.RELATED, 34, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                .addComponent(cancelButton)
                .addComponent(retryButton))
                .addGap(19, 19, 19)
            )
        );
        pack();
    }

    public static boolean showMessage(String terminalLabel, String message) {
        final ExceptionDialog dialog = new ExceptionDialog(new javax.swing.JFrame(), true);
        dialog.msgLabel.setText(message);
        dialog.setTitle(I18n.getString("terminal.exception.dialog", terminalLabel));
        dialog.setVisible(true);
        return dialog.retryChosen;
    }
}
