/*
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.javatest;

import com.sun.javatest.TestDescription;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * TestDescription extension that allows to indicate whether
 * this test is executed second time, i.e. rerun of this test
 * was requested.
 *
 * @author Mikhail Smirnov
 */
public class RerunnableTestDescription extends TestDescription {

    private boolean rerun = false;

    public RerunnableTestDescription(TestDescription td) {
        super(new File(td.getRootDir()), td.getFile(), createMap(td));
    }

    /**
     * This method is called to indication that this test will be executed second time
     */
    void setRerun() {
        rerun = true;
    }

    /**
     * @return true if this test is executed second time
     */
    public boolean isRerun() {
        return rerun;
    }

    private static Map createMap(TestDescription td) {
        Map hm = new HashMap();
        for (Iterator i = td.getParameterKeys(); i.hasNext();) {
            String next = (String) i.next();
            hm.put(next, td.getParameter(next));
        }
        return hm;
    }
}
