/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ArrayList;


import com.sun.interview.Interview;
import com.sun.interview.Question;

public class StringQuestion extends com.sun.interview.StringQuestion
    implements InterviewEntry {
    private InterviewPathResolver resolver = InterviewPathResolver.Null;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private String key;
    
    public StringQuestion(Interview interview, String tag,
                          Validator validator, Map map) {
        super(interview, tag);
        this.setValidator(validator);
        this.map = (map == null) ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }
    
    public StringQuestion(Interview interview, String tag,
                          Validator validator, Map map, String[] suggections) {
        this(interview, tag, validator, map);
        if (suggections != null) {
            this.setSuggestions(suggections);
        }
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setValue(String value) {
        if (validator.accept(this.tag, value, map)) {
            map.put(this.tag, value);
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(value));
        }
        super.setValue(value);
    }

    public void setKey(String key) {
        this.key = key;
    }
    
    public void export(Map map) {
        if (key != null) {
            map.put(this.key, this.value);
        }
    }

    public void clear() {
        if (map == null) {
            return;
        }
        if ((this.defaultValue == null) || !(this.defaultValue instanceof String)) {
            setValue(null);
        } else {
            setValue((String)this.defaultValue);
        }
    }
    
    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = (resolver == null) ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = (validator == null) ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return (validator.accept(this.tag, getValue(), map)
                ? resolver.getNext(this.tag)
                : validator.getErrorQuestion(this.tag, getValue(), map));
    }

    private ArrayList listeners = new ArrayList();
    
    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}
