/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ArrayList;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.Interview.Fault;

public class IntQuestion extends com.sun.interview.IntQuestion
    implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private String key;
    
    public IntQuestion(Interview interview, String tag,
                       Validator validator, Map map) {
        super(interview, tag);
        this.setValidator(validator);
        this.map = (map == null) ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }
    
    public IntQuestion(Interview interview, String tag, int min, int max,
                       Validator validator, Map map) {
        super(interview, tag, min, max);
        this.setValidator(validator);
        this.map = (map == null) ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
    }


    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setValue(int value) {
        Integer refValue = new Integer(value);
        if (validator.accept(this.tag, refValue, map)) {
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(Integer.toString(value)));
            
            map.put(this.tag, refValue);
        }
        super.setValue(value);
    }      
    
    public void setValue(String value) throws Fault {
        if (validator.accept(this.tag, value, map)) {
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(value));
            map.put(this.tag, value);
        }
        super.setValue(value);
    }

    public void setKey(String key) {
        this.key = key;
    }
    
    public void export(Map map) {
        if (key != null) {
            map.put(this.key, getStringValue());
        }
    }

    public void clear() {
        if (map == null) {
            return;
        }
        if (this.defaultValue == null) {
            super.clear();
        }  else if (this.defaultValue instanceof Integer) {
            setValue(((Integer)defaultValue).intValue());
        } else if (this.defaultValue instanceof String) {
            try {
                setValue((String)this.defaultValue);
            } catch (Fault e) {
                super.clear();
            }
        } else {
            super.clear();
        }
    }
    
    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = (resolver == null) ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = (validator == null) ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return (validator.accept(this.tag, new Integer(getValue()), map)
                ? resolver.getNext(this.tag)
                : validator.getErrorQuestion(this.tag, new Integer(getValue()), map));
    }

    private ArrayList listeners = new ArrayList();
    
    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}
