/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import com.sun.interview.Interview;
import com.sun.interview.Question;

public class FileListQuestion extends com.sun.interview.FileListQuestion
    implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private ArrayList listeners = new ArrayList();
    protected String key;
    
    public FileListQuestion(Interview interview, String tag,
                            Validator validator, Map map) {
        super(interview, tag);
        this.setValidator(validator);
        this.map = (map == null) ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }
    
    public void setKey(String key) {
        this.key = key;
    }
    
    public void export(Map map) {
        if (key != null) {
            map.put(this.key, getStringValue());
        }
    }
    
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }
    
    public void setValue(String value) {
        if (validator.accept(this.tag, value, map)) {
            map.put(this.tag, value);
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(value));
        }
        super.setValue(value);
    }

    public void setValue(File[] value) {
        String strValue = join(value);
        if (validator.accept(this.tag, value, map)) {
            map.put(this.tag, strValue);
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(strValue));
        }
        super.setValue(value);
    }
    
    public void clear() {
        if (map == null) {
            return;
        }
        if (this.defaultValue == null) {
            setValue((String)null);
        } else if (this.defaultValue instanceof File[]) {
            setValue((File[])this.defaultValue);
        } else if (this.defaultValue instanceof String[]) {
            setValue(createFileList((String[])this.defaultValue));
        } else if (this.defaultValue instanceof String) {
            setValue((String)this.defaultValue);
        } else {
            setValue((String)null);
        }
    }
    
    public File[] createFileList(String[] list) {
        ArrayList retVal = new ArrayList();
        for (int i = 0; i < list.length; i++) {
            File current = new File(list[i]);
            if (current.exists()) {
                retVal.add(current);
            }
        }
        return (File[])retVal.toArray(new File[retVal.size()]);
    }

    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = (resolver == null) ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = (validator == null) ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return (validator.accept(this.tag, getAbsoluteValue(), map)
                ? resolver.getNext(this.tag)
                : validator.getErrorQuestion(this.tag, getValue(), map));
    }

    public File[] getAbsoluteValue() {
        File[] list = getValue();
        File root = getBaseDirectory();
        if ((root != null) && (list != null)) {
            for (int i = 0; i < list.length; i++) {
                if (!list[i].isAbsolute()) {
                    list[i] = new File(root, list[i].getPath());
                }
            }
        }
        return list;
        
    }
                
    
    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}
