/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ArrayList;

import com.sun.interview.Interview;
import com.sun.interview.Question;

public class ChoiceQuestion extends com.sun.interview.ChoiceQuestion implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private ArrayList listeners = new ArrayList();
    private String key;
    
    public ChoiceQuestion(Interview interview, String tag, String[] choices,
                          Validator validator, Map map) {
        this(interview, tag, choices, null, validator, map);
    }
    
    public ChoiceQuestion(Interview interview, String tag, String[] choices,
                          String[] displayChoices, Validator validator, Map map) {
        super(interview, tag);
        this.setChoices(choices, (displayChoices == null) ? choices : displayChoices);
        this.setValidator(validator);
        this.map = (map == null) ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }
    
    public void setKey(String key) {
        this.key = key;
    }
    
    public void export(Map map) {
        if (key != null) {
            map.put(this.key, this.value);
        }
    }
    
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }
    
    public void setValue(String value) {
        if (validator.accept(this.tag, value, map)) {
            map.put(this.tag, value);
            for (Iterator e = listeners.iterator(); e.hasNext();
                 ((ValueSetListener)e.next()).valueSet(value));
        }
        super.setValue(value);
    }
    
    public void clear() {
        if (map == null) {
            return;
        }
        String[] choices = getChoices();
        for (int i = 0; i < choices.length; i++) {
            if (choices[i].equals(this.defaultValue)) {
                setValue(choices[i]);
                return;
            }
        }
        setValue(null);
    }
        
    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = (resolver == null) ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = (validator == null) ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return (validator.accept(this.tag, getValue(), map)
                ? resolver.getNext(this.tag)
                : validator.getErrorQuestion(this.tag, getValue(), map));
    }

    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}
