/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview;

import java.io.File;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.FileQuestion;
import com.sun.tck.jc.interview.lib.StringQuestion;
import com.sun.tck.jc.interview.lib.YesNoQuestion;
import com.sun.tck.jc.interview.lib.CompositeInterview;
import com.sun.tck.jc.interview.lib.Validator;
import java.io.FileInputStream;
import java.util.Properties;

public class BVTEnvInterview extends CompositeInterview {
    public static final String CONFIG_FILE_PROPERTY_NAME = "com.oracle.bvt.config";
    /* Tag names */
    public static final String PRODUCT = "product";
    public static final String CONFIG_NAME = "configName";
    public static final String DESCRIPTION = "description";
    public static final String BUNDLE_SIZE = "bundle_size";
    public static final String INT_SUPPORT = "int_support";
    public static final String JAVACARDX_CRYPTO_SUPPORT = "javacardx_crypto_support";
    public static final String CARD_SERVICE_CLASS = "CardServiceClass";
    public static final String CARD_PROXY_OPTIONS = "CardProxyOptions";
    public static final String SERVICE_PATH = "ServicePath";
    public static final String CLA_BYTE = "CLA_BYTE";
    public static final String DELETE_PACKAGE_AND_INSTANCES_SUPPORT = "deletePackageAndInstancesSupport";
    public static final String CARD_STORE_FILE = "CardStoreFile";
 
    /* Tag values */
    public static final String Install = "install";

    private StringQuestion configNameQuestion;

    private ResourceBundle i18nBundle;

    public BVTEnvInterview(Interview parent, String tag) {
        super(parent, tag);
        this.i18nBundle = getResourceBundle();

        this.configNameQuestion = new StringQuestion(this, CONFIG_NAME,
                                                     Validator.ConfigName, values,
                                                     new String[] {
                                                         i18n("product.JC_TCK"),
                                                         i18n("product.JavaCard_TCK")
                                                     });
        addQuestion(this.configNameQuestion, CONFIG_NAME);
        addQuestion(new StringQuestion(this, DESCRIPTION, Validator.NotEmpty,
                                       values,
                                       new String[] {
                                           i18n("description.complete_tck"),
                                           i18n("description.api")
                                       }), DESCRIPTION);
        addQuestion(new FileQuestion(this, CARD_STORE_FILE, Validator.NotEmpty, values),
                CARD_STORE_FILE);
    }

    @Override
    public boolean isApplicable(Question current) {
        return true;
    }
    
    public String getName() {
        return configNameQuestion.getStringValue();
    }

    public void setName(String name) {
        configNameQuestion.setValue(name);
    }

    public String getProduct() {
        return Install;
    }

    public void setRoot(String root) {
        String name = System.getProperty(CONFIG_FILE_PROPERTY_NAME);
        if (name == null) {
           name = root + File.separator + "lib" + File.separator + "config.properties";
        }
        loadProperties(name);
    }

    private void loadProperties(String fileName) {
        loadDefaults();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return;
            }
            Properties tmp = new Properties();
            tmp.load(new FileInputStream(fileName));
            for (Object key : tmp.keySet()) {
                values.put((String)key, tmp.getProperty((String)key));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String yesToTrue(String value) {
        return YesNoQuestion.YES.equals(value) ? "true" : "false";
    }

    public static String addCoverArg(String value, String arg) {
        if (value == null) {
            return "";
        }
        StringBuilder retVal = new StringBuilder();
        for (StringTokenizer e = new StringTokenizer(value, " \n\t");
             e.hasMoreTokens();) {
            retVal.append(arg);
            String current = e.nextToken();
            if (current.startsWith("\"")) {
                retVal.append(current);
            } else {
                retVal.append(" \"");
                retVal.append(current);
                retVal.append("\" ");
            } 
        }
        return retVal.toString();
    }

    @Override
    public void export(Map map) {
        map.putAll(values);
        map.put("JCTCK_HOME", "$testSuiteRootDir");
        map.put("JcTckClasses", "$JCTCK_HOME$/classes");
        map.put("libdir", "$JCTCK_HOME$/src$/share$/libs");
        map.put(CARD_PROXY_OPTIONS, addCoverArg(getValue(CARD_PROXY_OPTIONS), "-s"));
        
        map.put("ScriptArgs", "-install");
        map.put("command.install",
                "com.sun.javacard.cjck.invoke.CardTest $CardProxyOptions"
                + " -C $CardServiceClass -mode " + Install + " -Test \"$test\""
                + " -o \"$testWorkDir\" -classdir \"$JcTckClasses\""
                + " -exportdir \"$ExportPath$:$JCTCK_HOME$/export_files\""
                + " -bundle_size $bundle_size"
                + " -capfiledir \"$test\""
                + " -libdir $libdir"
                + " -get_response_cla_byte $CLA_BYTE"
                + " -executeClass $testExecuteClass $testExecuteArgs");
        super.export(map);
    }

    private String i18n(String key) {
        if (i18nBundle != null) {
            try {
                return i18nBundle.getString(key);
            } catch (MissingResourceException e) {
                return key;
            }
        } else {
            return key;
        }
    }

    private void loadDefaults() {
        values.put(CARD_SERVICE_CLASS, "com.sun.tck.bvtool.etsi.gp.GPOverETSICardService");
        values.put(SERVICE_PATH, "$JCTCK_HOME$/lib$/jctck-referenceimpl.jar$:l$JCTCK_HOME$/lib$/jctck-utils.jar");
        values.put(BUNDLE_SIZE, "0");
        values.put(CONFIG_NAME, "JC_TCK");
        values.put(DELETE_PACKAGE_AND_INSTANCES_SUPPORT, "true");
        values.put(DESCRIPTION, "Complete JC TCK Test Suite");
        values.put(INT_SUPPORT, "true");
        values.put(JAVACARDX_CRYPTO_SUPPORT, "true");
        values.put(PRODUCT, "install");
        values.put(CLA_BYTE, "0");
    }
}
