/*
 * %W% %E%
 * 
 * Copyright 2003 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.TestCase;

public class JCMultiTestEmitter extends JCExternalEmitter {

    public static interface TestType {
        public abstract String getExecuteClass();
        public abstract String getExecuteArgs();
        public abstract void setGroupName(String group_name);
        public abstract void setOutputDir(String outputDir);
        public abstract void createSources() throws TestFileException;
        public abstract String[] getConfigFiles() throws TestFileException;
        public abstract String[] getScriptFiles() throws TestFileException;
        public abstract String[] getAppletFiles() throws TestFileException;
    }
    
    protected void generateTestGroup(TestGroup tg, HashMap testSuites)
        throws TestFileException  {
        
        if (this.props == null) {
            this.props = new Properties();
        }
        
        this.output_Dir = createOutputDir(tg);
        
        this.group_name = tg.getID();
        this.group_name = (this.group_name == null) ? "Applet" : this.group_name;
        
        this.test = getTestType(tg);
        this.test.setOutputDir(this.output_Dir);
        this.test.setGroupName(this.group_name);
        this.test.createSources();
        super.setProperties(addCopyrightLink(this.props, tg));
        super.generateTestGroup(tg, testSuites);
    }

    /**
     * Constructs TestDescriptionIR by: id, title, tgAttr, CodeSet.
     */
    protected TestDescriptionIR constructTestDescriptionIR(String id, String title,
                                                           TestGroupAttributes tgAttr,
                                                           CodeSet codeSet,
                                                           TestCase tc, String context, String executeArgs)
        throws TestFileException {
        TestDescriptionIR retVal = super.constructTestDescriptionIR(id, title, tgAttr, codeSet, tc, context, executeArgs);

        retVal.set(TestDescriptionIR.EXECUTE_ARGS, this.test.getExecuteArgs());
        retVal.set(TestDescriptionIR.CLASS, this.test.getExecuteClass());
        return retVal;
    }

    protected TestType test;

    protected ArrayList getTestSources(CodeSet tgAttr) throws TestFileException {
        ArrayList retVal = super.getTestSources(tgAttr);
        addIfNotNull(retVal, this.test.getConfigFiles());
        addIfNotNull(retVal, this.test.getAppletFiles());
        return retVal;
    }

    protected ArrayList getClientTestSources(CodeSet tgAttr)
        throws TestFileException {
        ArrayList retVal = super.getClientTestSources(tgAttr);
        addIfNotNull(retVal, this.test.getScriptFiles());
        return retVal;
    }
    
    protected TestGroup[] splitTestGroup(TestGroup tg, HashMap tg2tc) {
        return new TestGroup[] {tg};
    }

    /**
     * returns interned String, which represents type of the TestGroup.
     */
    public TestType getTestType(TestGroup tg) throws TestFileException {
        CodeSet code = tg.getCodeSet();
        String baseClass = null;
        if ((code == null) || ((baseClass = code.getBaseClass()) == null)) {
            throw new TestFileException("There are no BaseClass");
        }
        String type = BuildProperties.getString(baseClass + ".type");
        if (Constants.DO_TEST_APPLET.equals(baseClass)
            || Constants.DO_TEST_APPLET_SHORT.equals(baseClass)
            || Constants.DO_TEST_APPLET_SHORT.equals(type)) {
            return new DoTest(tg, baseClass);
        } else {
            throw new TestFileException("Unsupported BaseClass: " + baseClass);
        }
    }
}
