/*
 * %W% %E%
 * 
 * Copyright 2003 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.util.ArrayList;

public class ECDescriptor implements BaseClassDescriptor {

    public String getSupportCode(String className) {
        return "    static ECPublicKey publicKey;\n"
            + "    static ECPrivateKey privateKey;\n"
            + "    static ECKey processingKey;\n"
            + "    static Signature sig;\n"
            + "    static KeyAgreement ka;\n"
            + "    static KeyAgreement ka1;\n"
            + "    static KeyAgreement ka2;\n\n"
            + "    /*\n"
            + "     * create an instance of Signature\n"
            + "     */\n"
            + "    public byte create_signature(byte algorithm, boolean externalAccess) {\n"
            + "        try {\n"
            + "            sig = Signature.getInstance(algorithm, externalAccess);\n"   
            + "            if (sig == null) {\n"
            + "                return CJCK_FAIL;\n"
            + "            }\n"
            + "        } catch (CryptoException e) {\n"
            + "            if (e.getReason() == CryptoException.NO_SUCH_ALGORITHM) {\n"
            + "                return (byte)0x01;\n"
            + "            } \n"
            + "            return CJCK_SYSERR;\n"
            + "        }\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    /*\n"
            + "     * create one instance of KeyAgreement\n"
            + "     */\n"
            + "    public byte create_keyagreement(byte algorithm, boolean externalAccess) {\n"
            + "        try {\n" 
            + "             ka = KeyAgreement.getInstance(algorithm, externalAccess);\n"   
            + "             if (ka == null) {\n"
            + "                return CJCK_FAIL;\n"
            + "            }\n"
            + "        } catch (CryptoException e) {\n"
            + "            if (e.getReason() == CryptoException.NO_SUCH_ALGORITHM) {\n"
            + "                return (byte)0x01;\n"
            + "            } \n"
            + "            return CJCK_SYSERR;\n"
            + "        }\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    /*\n"
            + "     * create two instance of KeyAgreement\n"
            + "     */\n"
            + "    public byte create_keyagreement2(byte algorithm, boolean externalAccess) {\n"
            + "        try {\n" 
            + "             ka1 = KeyAgreement.getInstance(algorithm, externalAccess);\n"   
            + "             ka2 = KeyAgreement.getInstance(algorithm, externalAccess);\n"   
            + "             if (ka1 == null || ka2 == null) {\n"
            + "                return CJCK_FAIL;\n"
            + "            }\n"
            + "        } catch (CryptoException e) {\n"
            + "            if (e.getReason() == CryptoException.NO_SUCH_ALGORITHM) {\n"
            + "                return (byte)0x01;\n"
            + "            } \n"
            + "            return CJCK_SYSERR;\n"
            + "        }\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    /*\n"
            + "     * create an instance of ECPrivateKey\n"
            + "     */\n"
            + "    public byte create_PrivateKey(short keyLength) {\n"
            + "        privateKey = null;\n"
            + "        processingKey = null;\n"
            + "        Key key = null;\n"
            + "        try {\n"
            + "            key = KeyBuilder.buildKey(KeyBuilder.TYPE_EC_FP_PRIVATE, keyLength, false);\n"
            + "            if (key == null || (!(key instanceof ECPrivateKey))) {\n"
            + "                return CJCK_FAIL1;\n"
            + "            }\n"
            + "        } catch (CryptoException e) {\n"
            + "            if (e.getReason() == CryptoException.NO_SUCH_ALGORITHM) {\n"
            + "                return (byte)0x01;\n"
            + "            } \n"
            + "            return CJCK_SYSERR;\n"
            + "        }\n"
            + "        try {\n"
            + "            if (key.getType() != KeyBuilder.TYPE_EC_FP_PRIVATE || \n"
            + "                key.getSize() != keyLength || \n"
            + "                key.isInitialized()) {\n"
            + "                return CJCK_FAIL2;\n"
            + "            }\n"
            + "        } catch (CryptoException e) { \n"
            + "            return CJCK_SYSERROR;\n"
            + "        }\n"
            + "        privateKey = (ECPrivateKey)key;\n"
            + "        processingKey = privateKey;\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    public byte setPrivateKey() {\n"
            + "        processingKey = privateKey;\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    /*\n"
            + "     * create an instance of ECPublicKey\n"
            + "     */\n"
            + "    public byte create_PublicKey(short keyLength) {\n"
            + "        publicKey = null;\n"
            + "        processingKey = null;\n"
            + "        Key key = null;\n"
            + "        try {\n"
            + "            key = KeyBuilder.buildKey(KeyBuilder.TYPE_EC_FP_PUBLIC, keyLength, false);\n"
            + "            if (key == null || (!(key instanceof ECPublicKey))) {\n"
            + "                return CJCK_FAIL1;\n"
            + "            } \n"
            + "        } catch (CryptoException e) {\n"
            + "            if (e.getReason() == CryptoException.NO_SUCH_ALGORITHM) {\n"
            + "                return (byte)0x01;\n"
            + "            } \n"
            + "            return CJCK_SYSERR;\n"
            + "        }\n"
            + "        try {\n"
            + "            if (key.getType() != KeyBuilder.TYPE_EC_FP_PUBLIC || \n"
            + "                key.getSize() != keyLength || \n"
            + "                key.isInitialized()) {\n"
            + "                return CJCK_FAIL2;\n"
            + "            }\n"
            + "        } catch (CryptoException e) { \n"
            + "            return CJCK_SYSERROR;\n"
            + "        }\n"
            + "        publicKey = (ECPublicKey)key;\n"
            + "        processingKey = publicKey;\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    public byte setPublicKey() {\n"
            + "        processingKey = publicKey;\n"
            + "        return CJCK_PASS;\n"
            + "    }\n\n"
            + "    /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_P(ECKey key, byte[] P, short offset, short length) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setFieldFP(P, offset, length);\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL3;\n"
            + "        }\n"
            + "    }\n\n"
            + "    /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_A(ECKey key, byte[] A, short offset, short length) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setA(A, offset, length);\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL4;\n"
            + "        }\n"
            + "    }\n\n"
            + "    /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_B(ECKey key, byte[] B, short offset, short length) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setB(B, offset, length);\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL5;\n"
            + "        }\n"
            + "    }\n\n"
            + "    /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_G(ECKey key, byte[] G, short offset, short length) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setG(G, offset, length);\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL6;\n"
            + "        }\n"
            + "    }\n\n"
            + "     /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_R(ECKey key, byte[] R, short offset, short length) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setR(R, offset, length);\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL7;\n"
            + "        }\n"
            + "    }\n\n"
            + "     /**\n"
            + "     * setup the ECDomain Parameters\n"
            + "     */\n"
            + "    public byte set_K(ECKey key, byte[] K, short offset) {\n"
            + "        try {\n"
            + "            if (key != null) {\n"
            + "                key.setK(Util.makeShort(K[(short)(offset)],\n"
            + "                                        K[(short)(offset + 1)]));\n"
            + "            }\n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL8;\n"
            + "        }\n"
            + "    }\n\n"
            + "    public byte set_S(byte[] S, short offset, short length) {\n"
            + "        try {\n"
            + "            if (privateKey != null) {\n"
            + "                privateKey.setS(S, offset, length);\n"
            + "            } \n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL9;\n"
            + "        }\n"
            + "    }\n\n"
            + "    public byte set_W(byte[] W, short offset, short length) {\n"
            + "        try {\n"
            + "            if (publicKey != null) {\n"
            + "                publicKey.setW(W, offset, length);\n"
            + "            } \n"
            + "            return CJCK_PASS;\n"
            + "        } catch (CryptoException e) {\n"
            + "            return CJCK_FAIL9;\n"
            + "        }\n"
            + "    }\n";
    }

    public ArrayList getImports(String className) {
        ArrayList list = new ArrayList();
        list.add("javacard.security.ECKey");
        list.add("javacard.security.Key");
        list.add("javacard.security.ECPublicKey");
        list.add("javacard.security.ECPrivateKey");
        list.add("javacard.security.Signature");
        list.add("javacard.framework.Util");
        list.add("javacard.security.KeyAgreement");
        list.add("javacard.security.KeyBuilder");
        list.add("javacard.security.CryptoException");
        return list;
    }

    public String getDoTestCode(String className) {
        return "            case 1:\n"
            + "                if (length < 2) {\n"
            + "                    return CJCK_SYSERR;\n"
            + "                }\n"
            + "                return create_signature(buffer[(short)offset],\n"
            + "                                        buffer[(short)(offset+1)] != 0);\n"
            + "            case 2:\n"
            + "                 if (length < 2) {\n"
            + "                    return CJCK_SYSERR;\n"
            + "                }\n"
            + "                return create_keyagreement(buffer[(short)offset],\n"
            + "                                           buffer[(short)(offset+1)] != 0);\n"
           + "             case 3:\n"
            + "                 if (length < 2) {\n"
            + "                    return CJCK_SYSERR;\n"
            + "                }\n"
            + "                return create_keyagreement2(buffer[(short)offset],\n"
            + "                                            buffer[(short)(offset+1)] != 0);\n"  
            + "            case 4:\n"
            + "                if (length < 2) {\n"
            + "                    return CJCK_SYSERR;\n"
            + "                }\n"
            + "                return create_PrivateKey(Util.makeShort(buffer[(short)(offset)],\n"
            + "                                                        buffer[(short)(offset + 1)]));\n"
            + "            case 5:\n"
            + "                if (length < 2) {\n"
            + "                    return CJCK_SYSERR;\n"
            + "                }\n"
            + "                return create_PublicKey(Util.makeShort(buffer[(short)(offset)],\n"
            + "                                                       buffer[(short)(offset + 1)]));\n"
            + "            case 6:\n"
            + "                return set_P(processingKey, buffer, offset, length);\n"
            + "            case 7:\n"
            + "                return set_A(processingKey, buffer, offset, length);\n"
            + "            case 8:\n"
            + "                return set_B(processingKey, buffer, offset, length);\n"
            + "            case 9:\n"
            + "                return set_G(processingKey, buffer, offset, length);\n"
            + "            case 10:\n"
            + "                return set_R(processingKey, buffer, offset, length);\n"
            + "            case 11:\n"
            + "                return set_K(processingKey, buffer, offset);\n"
            + "            case 12:\n"
            + "                return set_S(buffer, offset, length);\n"
            + "            case 13:\n"
            + "                return set_W(buffer, offset, length);\n"
            + "            case 14:\n"
            + "                return setPrivateKey();\n"
            + "            case 15:\n"
            + "                return setPublicKey();\n";
   }
                

    public int getFirstCase(String className) {
        return 16;
    }
}

