/*
 * %W% %E%
 * 
 * Copyright 2003 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.util.ArrayList;

/**
 * This interface defines plug-in, which is used for adding specific
 * functionality to the DoTest applet. For registering BaseClass, the followinh
 * entries shoule be added to the build properies:
 * <ul>
 *   <li>&lt;BaseClase&gt;.type = DoTestApplet
 *   <li>&lt;BaseClase&gt;.descriptor = <name of class, which implemets this
 *     interface. This class must declare public constructor without parameters.
 * </ul>
 */
public interface BaseClassDescriptor {

    /**
     * returns support code. JCMultiTestEmitter adds this code as is in class.
     * This code can define methods or fields required for the test execution.
     * @param className name of the created class.
     */
    public abstract String getSupportCode(String className);

    /**
     * returns list of imports or empty ArrayList if no imports are required.
     * @param className name of the created class.
     */
    public abstract ArrayList getImports(String className);

    /**
     * returns code, which should be added in the switch block inside doTest
     * methods. It can contain processing of special testcases used as protocol for Script.
     * For example:<br><pre>
            case 1:
                if (length < 3) {
                    return CJCK_SYSERR;
                }
                return create_PrivateKey(buffer[(short)offset] != 0,
                                         Util.makeShort(buffer[(short)(offset + 1)],
                                                        buffer[(short)(offset + 2)]));
            case 2:
                if (length < 3) {
                    return CJCK_SYSERR;
                }
                return create_PublicKey(buffer[(short)offset] != 0,
                                         Util.makeShort(buffer[(short)(offset + 1)],
                                                        buffer[(short)(offset + 2)]));
            case 3:
                return set_P(processingKey, buffer, offset, length);
</pre>
     */
    public abstract String getDoTestCode(String className);

    /**
     * returns the first code, which can be used for created testcases. It is
     * assumed the codes before this code are reserved for protocol cases
     * defined in code returned by getDoTestCode(String className) method.
     */
    public abstract int getFirstCase(String className);
}

        
