/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.FatalException;
import java.util.Observer;
import com.sun.tck.bvtool.terminal.CardStore;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import com.sun.tck.bvtool.terminal.Card;
/**
 * This class is a wrapper for CardTerminal class. It stores and allows to set
 * a state of wrapped CardTerminal instance.
 * 
 * @author Mikhail Smirnov
 */
public class StatefulCardTerminal extends CardTerminal {

    public enum State {CREATED, INVALID, VERIFIED, RECOVERED, REPLACEMENT_REQUIRED};
    
    private State state = State.CREATED;
    private CardTerminal terminal;
    private String label;
    private CardStore cards;
    private Card card;
    private CardPresenceNotifier cardPresenceNotifier;

    public StatefulCardTerminal(CardTerminal terminal) throws CardException {
        this(CardStore.getDefaultStore(), terminal);
    }

    public StatefulCardTerminal(CardStore cards, CardTerminal terminal) throws CardException {
        this.terminal = terminal;
        this.cards = cards;
        cardPresenceNotifier = new CardPresenceNotifier(this);
        new Thread(cardPresenceNotifier).start();
    }

    public boolean checkConnection() {
        try {
            terminal.connect("T=0");
            return true;
        } catch (CardException ex) {
            return false;
        }
    }

    public void addCardPresenceObserver(Observer observer) {
        cardPresenceNotifier.addObserver(observer);
    }

    public void removeCardPresenceObserver(Observer observer) {
        cardPresenceNotifier.deleteObserver(observer);
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setInsertedCardID(String cardID) throws FatalException {
        System.out.println("!! setInsertedCardID(" + cardID + ")");
        this.card = cards.findCard(cardID);
    }

    public Card getInsertedCard() {
        return card;//insertedCardID;
    }

    public State getState() {
        return state;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String toString() {
        return I18n.getString("stateful.terminal.name", terminal.toString(),
                label, state);
    }

    @Override
    public javax.smartcardio.Card connect(String protocol) throws CardException {
        return terminal.connect(protocol);
    }

    @Override
    public String getName() {
        return terminal.getName();
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return terminal.isCardPresent();
    }

    /**
     * Alternative method for isCardPresent() that doesn't throw CardException
     */
    public boolean checkCardPresent() {
        try {
            return terminal.isCardPresent();
        } catch (CardException ex) {
            return false;
        }
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        return terminal.waitForCardAbsent(timeout);
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        return terminal.waitForCardPresent(timeout);
    }
}
