/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.terminal;

import com.sun.tck.me.utils.Utils;
import com.sun.tck.bvtool.terminal.Card.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/**
 * This class contains the information about card, which is needed to be stored.
 *
 * @author Maxim V. Sokolnikov
 */
public class CardState implements Serializable {
    private static final long serialVersionUID = 2038300570653747929L;

    private transient File storageDir;

    public CardState() {
    }

    public CardState(File storageDir) {
        this.storageDir = storageDir;
    }

    String iccid;
    int keyVersion;
    Pair[] keys = new Pair[Card.NUMBER_OF_KEYS];
    int currentSecurityLevel;
    byte[] phone = Utils.parse("4455667788");
    LinkedHashMap<String, ArrayList<String>> installedCapFiles = new LinkedHashMap<String, ArrayList<String>>();

    void reset() {
        keyVersion = Card.DEFAULT_KEY;
        currentSecurityLevel = 0;
    }

    void flush() {
        if (storageDir == null) {
            return;
        }
        synchronized (this) {
            String name = storageDir + File.separator + iccid + ".data";
            File file = new File(name);
            File copy = null;
            if (file.exists()) {
                copy = new File(name + ".back");
                file.renameTo(copy);
            }
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(name));
                out.writeObject(this);
                out.close();
                if (copy != null) {
                    copy.delete();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static CardState create(File dir, String iccid) {
        CardState retVal = new CardState(dir);
        retVal.iccid = iccid;
        return retVal;
    }

    public static CardState restore(File dir, String iccid) {
        if ((dir == null) || (iccid == null)) {
            return create(dir, iccid);
        }
        String name = dir + File.separator + iccid + ".data";
        File file = new File(name);
        File copy = new File(name + ".back");
        file = copy.exists() ? copy : file;
        try {
            if (file.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                CardState restored = (CardState) in.readObject();
                restored.storageDir = dir;
                in.close();
                return restored;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return create(dir, iccid);
    }

    @Override
    public String toString() {
        return "(CardState " + "iccid=" + iccid
                + "\n    keyVersion=" + keyVersion
                + "\n    keys=" + arrayToString(keys)
                + "\n    currentSecurityLevel=" + currentSecurityLevel
                + "\n    phone=" + Utils.canonize(phone)
                + "\n    installedCapFiles=" + installedCapFiles + ')';
    }

    private static String arrayToString(Object[] list) {
        StringBuilder retVal = new StringBuilder("{");
        for (Object object : list) {
            retVal.append(" ").append(object);
        }
        retVal.append(" }");
        return retVal.toString();
    }

    public static void main(String[] args) {
        File root = null;
        ArrayList<String> iccids = new ArrayList<String>();
        for (int i = 0; i < args.length; i++) {
            if (args[i].equalsIgnoreCase("-storageDir")) {
                root = new File(args[++i]);
            } else {
                iccids.add(args[i]);
            }
        }
        for (String id : iccids) {
            System.out.println(id + " := " + CardState.restore(root, id));
        }
    }
}
