/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.tck.bvtool.terminal.CardPresenceNotifier.CardEvent;
import java.util.Observable;
import java.util.Observer;

/**
 * @author Mikhail Smirnov
 */
public abstract class CardPresenceObserver implements Observer {

    CardPresenceNotifier notifier;
    CardEvent event;

    @Override
    public void update(Observable o, Object arg) {
        notifier = (CardPresenceNotifier) o;
        event = (CardEvent) arg;
        notified(event);
    }

    public abstract void notified(CardEvent event);

    public StatefulCardTerminal getSourceTerminal() {
        return notifier.getTerminal();
    }

}
