/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.bvtool.terminal;

import java.util.Observable;
import javax.smartcardio.CardException;

/**
 * @author Mikhail Smirnov
 */
public class CardPresenceNotifier extends Observable implements Runnable {

    public enum CardEvent {CARD_INSERTED, CARD_REMOVED, INVALID_STATE};

    private StatefulCardTerminal terminal;
    private boolean wasCardPresent;

    public CardPresenceNotifier(StatefulCardTerminal terminal) throws CardException {
        this.terminal = terminal;
        wasCardPresent = terminal.isCardPresent();
    }

    public StatefulCardTerminal getTerminal() {
        return terminal;
    }

    @Override
    public void run() {
        while(true) {
            try {
                boolean isCardPresent = terminal.isCardPresent();
                if (isCardPresent != wasCardPresent) {
                    setChanged();
                    if (isCardPresent) {
                        notifyObservers(CardEvent.CARD_INSERTED);
                    } else {
                        notifyObservers(CardEvent.CARD_REMOVED);
                    }
                    wasCardPresent = isCardPresent;
                }
                Thread.yield();
            } catch (CardException ex) {
                terminal.setState(StatefulCardTerminal.State.INVALID);
                setChanged();
                notifyObservers(CardEvent.INVALID_STATE);
            }
        }
    }

    
}
