/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class TLVUtils {

    // TODO the precise BER implementation
    public static long lookupTag(TLVBuffer in) throws EncodingException {
        TLVBuffer.Position pos = in.createPosition();
        long retVal = readTag(in);
        in.setPosTo(pos.pos);
        return retVal;
    }

    public static long readTag(TLVBuffer in) throws EncodingException {
        long l = 0L;
        int c = in.read();
        if ((c & 0x1F) == 0x1F) {// Rule 8.1.2.4.1
            do {
                c = in.read();
                l <<= 7;
                l |= c & 0x7F;
            } while ((c & 0x80) != 0);
        } else {
            return c;
        }
        return l;
    }

    public static int readLength(TLVBuffer in) throws EncodingException {
        int current = in.read() & 0xff;
        int length = 0;
        if ((current & 0x80) != 0) {
            current &= 0x7f;
            for (int i = 0; i < current; i++) {
                length = (length << 8) | (in.read() & 0xff);
            }
        } else {
            length = current;
        }
        return length;
    }

    public static byte[] parse(long l) {
        return parse(l, -1);
    }

    public static byte[] parse(long l, int length) {
        if (length <= 0) {
            long curr = l;
            length = 0;
            while (curr != 0) {
                curr >>= 8;
                length++;
            }
            length = (length == 0) ? 1 : length;
        }
        byte[] retVal = new byte[length];
        for (int i = length - 1; i >= 0; i--) {
            retVal[i] = (byte)l;
            l >>= 8;
        }
        return retVal;
    }


    public static byte[] encode(TLV tlv) throws Exception {
        TLVBuffer buff = new TLVBuffer(10240);
        tlv.encode(buff);
        byte[] retVal = new byte[buff.getPos()];
        System.arraycopy(buff.getBuffer(), 0, retVal, 0, retVal.length);
        return retVal;
    }
    public static String toBinaryString(long value, int length, String delim) {
        StringBuffer buff = new StringBuffer();
        String dlm = "";
        for (int i = 0; i < length; i++) {
            buff.append(dlm);
            String val = Integer.toBinaryString((int)(value & 0xff));
            for (int j = 8 - val.length(); j > 0; j--) {
                buff.append('0');
            }
            buff.append(val);
            dlm = delim;
        }
        return buff.toString();
    }

    public static void encodeIntBy7Bits(TLVBuffer buff, long current) {
        long t = current;
        int length = 0;
        do {
            length ++;
            t >>>= 7;
        } while (t != 0);
        for (int shift = length * 7; shift > 0;) {
            shift -= 7;
            byte b = (shift == 0) ? (byte)0x00 : (byte)0x80;
            b |= (current >>> shift) & 0x7f;
            buff.write(b);
        }
    }

    public static void writeLength(TLVBuffer lengthBuff, int length) throws EncodingException {
        if (length <= 127) {
            lengthBuff.write(length);
        } else {
            int count = 0;
            int current = length;
            while (current != 0) {
                current >>= 8;
                count++;
            }
            lengthBuff.expand(count);
            lengthBuff.write(count | 0x80);
            for (int i = (count * 8 - 8); i >= 0; i -= 8) {
                lengthBuff.write(length >> i);
            }
        }
    }
    public static TLV parse(TLVPrototypeFactory factory, TLVBuffer in) throws Exception {
        TLV retVal = factory.create(TLVUtils.lookupTag(in));
        retVal.decode(factory, in);
        return retVal;
    }
}
