/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

import com.sun.tck.bvtool.etsi.data.CAPDUTLV;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.etsi.data.CommandPacket;
import com.sun.tck.bvtool.etsi.data.CommandScriptingTemplate;
import com.sun.tck.bvtool.etsi.gsm.ETSITags;
import com.sun.tck.bvtool.etsi.data.SecuredPacketTLV;
import com.sun.tck.bvtool.etsi.data.RAPDUTLV;
import com.sun.tck.bvtool.etsi.data.ResponsePacket;
import com.sun.tck.bvtool.etsi.data.ResponseScriptingTemplate;
import com.sun.tck.bvtool.etsi.gsm.GSMTags;
import com.sun.tck.bvtool.etsi.gsm.ProactiveCommandTLV;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.NULL_VALUE;
/**
 *
 * @author Maxim V. Sokolnikov
 */
public class TLVPrototypeFactory {
    private Card card;

    public TLVPrototypeFactory() {
        this(null);
    }

    public TLVPrototypeFactory(Card card) {
        this.card = card;
        registerClass(ETSITags.COMMAND_SCRIPT_TEMPLATE_TAG, CommandScriptingTemplate.class);
        registerClass(ETSITags.CPI_TAG, CommandPacket.class);
        registerClass(ETSITags.C_APDU_TAG, CAPDUTLV.class);
        registerClass(ETSITags.R_APDU_TAG, RAPDUTLV.class);
        registerClass(ETSITags.RESPONSE_SCRIPT_TEMPLATE_TAG, ResponseScriptingTemplate.class);
        registerClass(ETSITags.RPI_TAG, ResponsePacket.class);
//        registerClass(ETSITags.OBJECT_ID_TAG, ObjectIDTLV.class);
        registerClass(GSMTags.ProactiveSIMcommandTag, ProactiveCommandTLV.class);
    }

    private HashMap<Integer, Class> prototypes = new HashMap<Integer, Class>();

    public void setCard(Card card) {
        this.card = card;
    }

    public TLV create(Class cl) throws InstantiationException,
            InvocationTargetException, IllegalAccessException {
        if (cl == null) {
            return null;//new SkipTLV();
        }
        TLV tlv = (TLV) cl.newInstance();
        if (tlv instanceof SecuredPacketTLV) {
            ((SecuredPacketTLV)tlv).init(card);
        }
        return tlv;
    }


    public void registerClass(byte tag, Class cl) {
        prototypes.put(new Integer(0xFF &tag), cl);
    }
    // TODO the precise BER implementation
    public long readTag(TLVBuffer in) throws EncodingException {
        long l = 0L;
        int c = in.read();
        if ((c & 0x1F) == 0x1F) {// Rule 8.1.2.4.1
            do {
                c = in.read();
                l <<= 7;
                l |= c & 0x7F;
            } while ((c & 0x80) != 0);
        } else {
            return c;
        }
        return l;
    }

    public TLV create(long tag) 
            throws InstantiationException, InvocationTargetException, 
                IllegalAccessException, EncodingException {
        return create(tag, null);
    }

    public TLV create(long tag, ConstantBundle constants)
            throws InstantiationException, InvocationTargetException,
                IllegalAccessException, EncodingException {
        TLV tlv = create(find((byte)tag));
        if (constants != null) {
            tlv.constants = constants;
        }
        tlv.setTag((byte)tag, null);
        if (tlv instanceof SecuredPacketTLV) {
            ((SecuredPacketTLV)tlv).init(card);
            ((SecuredPacketTLV)tlv).setCompactMode(false);
        }
        return tlv;
    }

    private Class find(byte tag) {
        Class retVal = prototypes.get(new Integer(0xFF & tag));
        if (retVal != null) {
            return retVal;
        }
        return ((tag & 0x20) == 0) ? RawTLV.class : ConstructedTLV.class;
    }
}
