/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;
import com.sun.tck.me.utils.Utils;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class RawTLV extends TLV {
    protected byte[] data;
    public Object object;

    public RawTLV() {
    }

    public RawTLV(byte tag, String data) {
        this(tag, Utils.parse(data));
    }

    public RawTLV(byte tag, byte[] data) {
        setTagInternal(tag, null);
        this.data = data;
    }

    public byte[] getData() {
        return data;
    }

    @Override
    protected void writeData(TLVBuffer buff) throws Exception {
        buff.write(data);
    }

    @Override
    public void decodeData(TLVPrototypeFactory processor, TLVBuffer in) throws Exception {
        this.data = in.readArray(in.available());
    }

    @Override
    protected StringBuffer toStringHeader() {
        return super.toStringHeader().append(", value=").append(Utils.canonize(data));
    }
}
