/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ConstructedTLV extends TLV {

    public ConstructedTLV(byte tag, TLV... list) {
        for (TLV tlv : list) {
            add(null, tlv);
        }
    }

    public ConstructedTLV() {
    }


    @Override
    protected void writeData(TLVBuffer buff) throws Exception {
        for (TreeNode child : childNodes().values()) {
            if (child instanceof Encodable) {
                ((Encodable)child).encode(buff);
            }
        }
    }

    @Override
    public void decodeData(TLVPrototypeFactory processor,  TLVBuffer in) throws Exception {
        while (in.available() > 0) {
            long tag = TLVUtils.lookupTag(in);
            createChild(tag, processor, in);
        }
    }

    public void createChild(long tag, TLVPrototypeFactory processor,
            TLVBuffer in) throws Exception {
        TLV child = processor.create(tag, constants);
        child.decode(processor, in);
        child.constants = constants;
        add(null, child);
    }

    public TLV find(byte tag) {
        for (TreeNode tlv : childNodes().values()) {
            if ((tlv instanceof  TLV) && ((TLV)tlv).getTag() == tag) {
                return (TLV)tlv;
            }
        }
        return null;
    }
}
