/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.security;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public enum KeyType {
        DES_CBC(1, "DES/CBC/NoPadding"),
        DES_ECB(13, "DES/ECB/NoPadding"),
        TRIPLE_DES_CBC_2_OF_3(5, "DESede/CBC/NoPadding"),
        TRIPLE_DES_CBC(9, "DESede/CBC/NoPadding");

        private byte code;
        private String name;

        private KeyType(int code, String name) {
            this.code = (byte)code;
            this.name = name;
        }

        public Cipher createCipher(int mode, byte[] password, boolean doEncrypt) throws GeneralSecurityException {
            Cipher retVal = Cipher.getInstance(name);
            if (name.indexOf("/CBC/") > 0) {
                byte[] iv = new byte[] { (byte)0x00, 0x00, 0x00, (byte)0x00, 0x00, 0x00, 0x00, 0x00  };
                if (doEncrypt) {
                    Cipher step = Cipher.getInstance(name);
                    AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
                    step.init(mode, createKeyForSignature(name, password), paramSpec);
                    iv = step.doFinal(iv);
                }
                AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
                retVal.init(mode, createKeyForSignature(name, password), paramSpec);
            } else {
                retVal.init(mode, createKeyForSignature(name, password));
            }
            return retVal;
        }

        public byte getCode() {
            return code;
        }
    public static Key createKeyForSignature(String sigName, byte[] password) throws GeneralSecurityException {
        String keyName = sigName.substring(0, sigName.indexOf('/'));
        SecretKeyFactory factory = SecretKeyFactory.getInstance(keyName);
        KeySpec spec;
        if ("DES".equals(keyName)) {
            spec = new DESKeySpec(password);
        } else { // triple des
            byte[] data;
            if (password.length < 24) {
                data = new byte[24];
                System.arraycopy(password, 0, data, 0, password.length);
                System.arraycopy(password, 0, data, password.length, 24 - password.length);
            } else {
                data = password;
            }
            spec = new DESedeKeySpec(data);
        }
        return factory.generateSecret(spec);
    }
}
