/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.security;

import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

/**
 *
 * @author Maxim V. Sokolnikov
 */
    public class CryptographicChecksum extends Checksum {
         byte[] buff = new byte[8];
         byte[] checksum = new byte[8];
         int pos;

         public CryptographicChecksum(KeyDescr key) {
             this.key = key;
         }

/*        @Override
        public byte encodeKey() {
            return key.encodeKey();
        }
*/
        @Override
        public int getLength() {
            return 8;
        }

        @Override
         public byte getCode() {
             return  2; // 10: Cryptographic Checksum
         }
//            } if (isCRC) {
//                code |= 1; // 01: Redundancy Check
//            }
//            return code;
//        }
//        Signature signature; // TODO
        KeyDescr key;

        @Override
        public void update(byte[] data, int offset, int length)
                throws GeneralSecurityException {
            int processed = 0;
            int blockSize = getLength();
            while (processed < length) {
                if (pos == blockSize) {
                    checksum = this.key.cipher.update(buff);
                    pos = 0;
                }
                int toDo = Math.min(blockSize - this.pos, length - processed);
                System.arraycopy(data, offset + processed, buff, this.pos, toDo);
                processed += toDo;
                pos += toDo;
            }
        }


        @Override
        public byte[] calculateCheckSum() throws GeneralSecurityException {
            while (pos < buff.length) {
                buff[pos++] = (byte)0;
            }
            checksum = this.key.cipher.doFinal(buff);
            pos = 0;
            return checksum;
        }

    @Override
    public String toString() {
        return "CryptographicChecksum{" + "key=" + key + '}';
    }
}
