/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gp;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.etsi.gsm.SMSChannel;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.TLVEncoder;
import com.sun.tck.me.utils.User;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.me.utils.CommandLine;
import com.sun.tck.me.utils.CommandLineAdapter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
/**
 *
 * @author Maxim V. Sokolnikov
 */
public class GPOverETSICardService extends GPCardService {
    private static final int SINGLE_SMS_HEADER_LENGTH = 150;
    private static final int HEADER_LENGTH = 37;
    private static final int APDU_LENGTH = 254;

    private SMSChannel cards;
    private boolean useSmsChain = true;
    private int bundleSize = 4;


    public GPOverETSICardService() {
        parser = new TLVPrototypeFactory();
        cards = new SMSChannel(this);
    }

    public void setCard(Card card) {
        this.parser.setCard(card);
        cards.setCard(card);
        this.card = card;
    }

    public void setSmsChainMode(boolean useSmsChain) {
        this.useSmsChain = useSmsChain;
    }

    @Override
    public ResponseAPDU sendApduToCardManager(CommandAPDU apdu) throws CardProxyException {
        return sendApduListToCardManager(apdu).get(0);
    }

    public void setBundleSize(int bundleSize) {
        this.bundleSize = bundleSize;
    }

    @Override
    public List<ResponseAPDU> sendApduListToCardManager(CommandAPDU... apdus) throws CardProxyException {
        int currentBundleSize = useSmsChain ? bundleSize : 1;
        if (apdus.length > currentBundleSize) {
            ArrayList<ResponseAPDU> retVal = new ArrayList<ResponseAPDU>();
            int pos = 0;
            while (pos < apdus.length) {
                int length = Math.min(currentBundleSize, apdus.length - pos);
                CommandAPDU[] part = new CommandAPDU[length];
                System.arraycopy(apdus, pos, part, 0, length);
                retVal.addAll(sendApduListToCardManager(part));
                pos += length;
            }
            return retVal;
        }
        try {
            out("===================sendApduToCardManager===================");
            for (CommandAPDU apdu : apdus) {
                out("  " + apdu);
            }
            out("===========================================================");
            List<ResponseAPDU> list = cards.sendSMS(apdus);
            out("LIST:" + list);
            return list;
        } catch (CardProxyException e) {
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new CardProxyException("Error:" + ex);
        }
    }

    @Override
    public void resetCard() throws CardProxyException {
    }

    @Override
    public void selectInstaller() throws CardProxyException {
        reset();
    }

    @Override
    public void setCardTerminal(StatefulCardTerminal terminal) {
        super.setCardTerminal(terminal);
        setCard(terminal.getInsertedCard());
    }


    @Override
    protected Object[] getConfigurables() {
        // TODO create configurator
        return super.getConfigurables();
//        SMSChannel init = this.getSMSChannel();
//        CardStore store = init.getCards();
//        return new Object[] { store.getPrototype(), store, this };
    }

    @Override
    public void stopTest() throws CardProxyException {
        super.stopTest();
        try {
            if (card != null) {
                card.flush();
            }
            CardStore store = CardStore.getDefaultStore();
            synchronized (store) {
                store.close();
            }
        } catch (CardProxyException e) {
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace(); // TODO
        }
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        super.init(args, out, ref);
        cards.setUser(User.createNotInteractiveUser(out));
    }


    public ResponseAPDU send_sms(CommandAPDU apdu) throws CardProxyException {
        return sendApduToCardManager(apdu);
    }

    public ResponseAPDU send(CommandAPDU apdu) throws CardProxyException {
        return sendAPDU(apdu);
    }

    @Override
    public void powerDown() throws CardProxyException {
        super.powerDown();
        cards.powerReset();
    }

    @Override
    public int getHeaderLength() {
        return useSmsChain ? super.getHeaderLength() : SINGLE_SMS_HEADER_LENGTH;
    }

    @Override
    public boolean deleteObject(AppletID aid, boolean deleteRelated) throws CardProxyException {
        try {
            return super.deleteObject(aid, deleteRelated);
        } catch (DeploymentException e) {
            e.printStackTrace();
            e.printStackTrace(out);
            return false;
        }
    }

    @Override
    public boolean installCAPFile(AppletProperties[] applets, String catFile, String outputDir) throws CardProxyException {
        try {
            return super.installCAPFile(applets, catFile, outputDir);
        } catch (DeploymentException e) {
            if (!useSmsChain) {
                throw e;
            }
        }
        out("SMS-PROTOCOL:Deployment of the cap file using multiply SMS fails.");
        out("Trying to use single SMS");
        boolean useSmsChainStored = useSmsChain;
        useSmsChain = false;
        try {
            return super.installCAPFile(applets, catFile, outputDir);
        } finally {
            useSmsChain = useSmsChainStored;
        }
    }

    @Override
    protected void encodeInstallParameters(TLVEncoder out, AppletProperties applet) throws EncodingException {
        super.encodeInstallParameters(out, applet);
//        encodeUICC_SystemSpecificParameters(out, applet);
    }

 
    /* Install parameters field
     *  +->0xEA - UICC System Specific Parameters" TLV object
     *     +->0x80 - UICC Toolkit Application specific parameters field
     *     +->0xC3 - UICC Toolkit parameters DAP
     *     +->0x81 - UICC Access Application specific parameters field
     *     +->0x82 - UICC Administrative Access Application specific parameters field
     *  +->0xEF - System Specific Parameters"
     *     +->0xCA - SIM File Access and Toolkit Application Specific Parameters
     */
    protected void encodeUICC_SystemSpecificParameters(TLVEncoder out, AppletProperties applet) throws EncodingException {
        String[] menu = new String[] {
            "demo1"
        };
        // 0xEA - UICC System Specific Parameters" TLV object
        out.startTag(0xEA, "UICC System Specific Parameters");
    
        // UICC Toolkit Application specific parameters field
        out.startTag(0x80, "UICC Toolkit Application specific parameters");
// 1 Priority level of the Toolkit application instance
        out.out().write(1);
// 1 Maximum number of timers allowed for this application instance
        out.out().write(1);
// 1 Maximum text length for a menu entry
        out.out().write(16);
// 1 Maximum number of menu entries allowed for this application instance = m
        out.out().write(menu.length);
        for (int i = 0; i < menu.length; i++) {
// 1 Position of the first menu entry \
            out.out().write(i);
// 1 Identifier of the first menu entry ('00' means do not care) |
            out.out().write(0x00);
//                                                            …. | = 2 × m bytes
// 1 Position of the last menu entry |
// 1 Identifier of the last menu entry ('00' means do not care) /
        }
// 1 Maximum number of channels for this application instance
        out.out().write(4);
// 1 Length of Minimum Security Level field
        out.out().write(0); // I don't think you need it for a demo
// 0-q Minimum Security Level (MSL)
// 1 Length of TAR Value(s) field
        out.out().write(3);
// 3 × y TAR Value(s) of the Toolkit Application instance
        out.out().write(1); // choose your TAR
        out.out().write(1);
        out.out().write(1);
        // 1 Maximum number of services for this application instance
        out.out().write(1);
        out.end("UICC Toolkit Application specific parameters");
        out.end("UICC System Specific Parameters");
    }

    public static void main(String[] list) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        GPOverETSICardService service = new GPOverETSICardService();
        GSMCardConfigurator configurator = new GSMCardConfigurator();
        try {
            CommandLine cmd = new CommandLine(service);
            CommandLineAdapter adapter = new CommandLineAdapter(
                    service, cmd, configurator);
            adapter.init(list);
            configurator.init();
            service.setCard(configurator.getCard());
            service.init(new String[0], out, out);
            service.startTest(".", 10);
            out.flush();
            service.cards.setUser(cmd.isBatch()?  User.NOT_INTERACTIVE : User.INTERACTIVE);
            cmd.run();
        } finally {
            configurator.close();
            out.flush();
            Card card = configurator.getCard();
            if (card != null) {
                card.flush();
            }
        }
    }
}
