/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gp;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.bvtool.etsi.security.KeyDescr;
import com.sun.tck.bvtool.etsi.security.KeyType;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ExternalAuthenticator {
    public static class CMac {
        // ToDo Chain processing
        Cipher des;
        Key trippleDesKey;

        public CMac(byte[] key) throws Exception {
            des = Cipher.getInstance("DES/CBC/NoPadding");
            byte[] iv = new byte[] { (byte)0x00, 0x00, 0x00, (byte)0x00, 0x00, 0x00, 0x00, 0x00  };
            AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
            des.init(Cipher.ENCRYPT_MODE, KeyType.createKeyForSignature("DES/CBC/NoPadding", key), paramSpec);
            trippleDesKey = KeyType.createKeyForSignature("DESede/CBC/NoPadding", key);
        }

        public byte[] sign(byte[] data) throws Exception {
            return sign(data, 0, data.length);
        }

        public void signApdu(byte[] data, int offset, int length) throws Exception {
            byte[] checksum = sign(data, offset, length);
            System.arraycopy(checksum, 0, data, offset + length, checksum.length);
        }

        public byte[] sign(byte[] data, int offset, int length) throws Exception {
            byte[] first = des.doFinal(data, offset, length - 8);
            AlgorithmParameterSpec paramSpec = new IvParameterSpec(getTail(first));
            Cipher trippleDes = Cipher.getInstance("DESede/CBC/NoPadding");
            trippleDes.init(Cipher.ENCRYPT_MODE, trippleDesKey, paramSpec);
            return trippleDes.update(data, offset + length - 8, 8);
        }
    }
    private byte[] s_enc;
    private byte[] c_mac;

    public ExternalAuthenticator(String s_enc, String c_mac) {
        this(Utils.parse(s_enc), Utils.parse((c_mac == null) ? s_enc : c_mac));
    }

    public ExternalAuthenticator(byte[] s_enc, byte[] c_mac) {
        this.s_enc = s_enc;
        this.c_mac = (c_mac == null) ? s_enc : c_mac;
    }

    public CommandAPDU createAnswer(byte[] hostChallenge, byte[] fromCard) throws Exception {
        byte[] data = new byte[16];
        data[0] = (byte)0x84;
        data[1] = (byte)0x82;
        data[2] = (byte)0x00;
        data[3] = (byte)0x00;
        data[4] = (byte)0x10;
        byte[] hostData = new byte[24];
        System.arraycopy(fromCard, 12, hostData, 0, 8);
        System.arraycopy(hostChallenge, 0, hostData, 8, 8);
        hostData[16] = (byte)0x80; // Padding

        int counter = (fromCard[12] << 8 | fromCard[13]) & 0xffff;
//        System.out.println("Counter=" + counter);
        KeyDescr key = new KeyDescr(KeyType.TRIPLE_DES_CBC, 1, getDerived(this.s_enc, 0x0182, counter));
        CMac macKey = new CMac(getDerived(this.c_mac, 0x0101, counter));

        byte[] cryptogtam = getTail(key.cipher.doFinal(hostData));
//        System.out.println("data    =" + TLVUtils.canonize(hostData));
//        System.out.println("checksum=" + TLVUtils.canonize(cryptogtam));
        System.arraycopy(cryptogtam, 0, data, 5, 8);
        data[13] = (byte)0x80;
//        System.out.println("macData=" + TLVUtils.canonize(data));
        byte[] mac = macKey.sign(data);
//        System.out.println("mac    =" + TLVUtils.canonize(mac));
        byte[] apdu = new byte[21];
        System.arraycopy(data, 0, apdu, 0, 13);
        System.arraycopy(mac, 0, apdu, 13, 8);
        return new CommandAPDU(apdu);
    }
    static String password = "4041424344454647 48494A4B4C4D4E4F";
    public static void mainOld(String[] args) throws Exception {
        ExternalAuthenticator test = new ExternalAuthenticator(password, password);
        CommandAPDU auth = test.createAnswer(Utils.parse("1122334455667788"),
                Utils.parse("00001048 2591b33c 2938ff02 00003d02 9c31c789 109159b6 9dd1e8f7"));
        System.out.println("Returned: " + Utils.canonize(auth.getBytes()));
        System.out.println("Expected: 84820000106cabf34acfaa6ccbf3463ebd51ae8a55");
        /*
        KeyDescr sEnc = new KeyDescr(KeyType.TRIPLE_DES_CBC, 1, TLVUtils.parse(password));
        KeyDescr key = new KeyDescr(KeyType.TRIPLE_DES_CBC, 1, getDerived(TLVUtils.parse(password), 0x0182, 0));
        CMac mac = new CMac(getDerived(TLVUtils.parse(password), 0x0101, 0));
        String challenge = "0000:3d02:9c31c789  11223344:55667788  80000000:00000000";
        byte[] data = TLVUtils.parse(challenge);
        byte[] macData = TLVUtils.parse("84820000 10:6cabf3 4acfaa6ccb800000");
        System.out.println("data=" +  TLVUtils.canonize(data));
        System.out.println("checksum=" + getTailString(key.cipher.doFinal(data), 8));
        System.out.println("mac     =" + TLVUtils.canonize(mac.sign(macData)));//getTailString(macKey.cipher.doFinal(macData), 8));
//        System.out.println("");
//        System.out.println(TLVUtils.canonize(ch.externalAuthenticate(TLVUtils.parse(
//                "00 00 10 48 25 91 b3 3c 29 38 ff 02 00 00 3d 02 9c 31 c7 89 10 91 59 b6 9d d1 e8 f7")).getBytes()));
        System.out.println("expected=6cabf34acfaa6ccb f3463ebd51ae8a");*/
    }
    private static byte[] getDerived(byte[] keyData, int base, int counter) throws GeneralSecurityException {
        byte[] data = new byte[16];
        data[0] = (byte)(base >> 8);
        data[1] = (byte)base;
        data[2] = (byte)(counter >> 8);
        data[3] = (byte)counter;
        KeyDescr key = new KeyDescr(KeyType.TRIPLE_DES_CBC_2_OF_3, 1, keyData);
        return key.cipher.doFinal(data);
    }
    private static byte[] getTail(byte[] data) {
        byte[] retVal = new byte[8];
        System.arraycopy(data, data.length - 8, retVal, 0, 8);
        return retVal;
    }
    private static String getTailString(byte[] data, int length) {
        byte[] retVal = new byte[length];
        System.arraycopy(data, data.length - length, retVal, 0, length);
        return Utils.canonize(retVal);
    }
    public static void main(String[] args) throws Exception {
        CMac mac = new CMac(Utils.parse("01 23 45 67 89 AB CD EF 10 02 76 FE DC BA 01 23"));
//        String data = "0030150e19252500" +
//                      "0000000000000203" +
//                      "80e602001207a000" +
//                      "0000185060000006" +
//                      "ef04c60201d80000" +
//                      "0000000000000000";
//        new Part("000000", false)
//        System.out.println(TLVUtils.canonize(mac.sign(TLVUtils.parse(data))));
        KeyDescr key = new KeyDescr(KeyType.TRIPLE_DES_CBC_2_OF_3, 1, Utils.parse("112233445566778899AABBCCDDEEFF00"));
        String data = "0035150221001500000000000000000080E602001A0FA00000006203010A01010103010101000006EF04C60201110000";
        System.out.println(getTailString(key.cipher.doFinal(Utils.parse(data)), 8));
    }
}
