/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.RESPONSE_SCRIPT_TEMPLATE_TAG;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.NUMBER_OF_EXECUTED_APDUS;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import java.util.ArrayList;
/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ResponseScriptingTemplate extends ConstructedTLV {
    int apduCount;
    private ArrayList<ResponseAPDU> responses = new ArrayList<ResponseAPDU>();

    public ResponseScriptingTemplate() {
        super(RESPONSE_SCRIPT_TEMPLATE_TAG);
    }

    public ResponseScriptingTemplate(ResponseAPDU... answers) {
        this(answers.length, answers);

    }

    public ResponseScriptingTemplate(int apduCount, ResponseAPDU... answers) {
        setTagInternal(RESPONSE_SCRIPT_TEMPLATE_TAG, null);
        for (ResponseAPDU apdu : answers) {
            responses.add(apdu);
        }
        this.apduCount = apduCount;
        add("processed-count", new RawTLV(NUMBER_OF_EXECUTED_APDUS, TLVUtils.parse(apduCount)));
        for (ResponseAPDU apdu : responses) {
            add(new RAPDUTLV(apdu));
        }
    }

    public ArrayList<ResponseAPDU> getResponses() {
        return responses;
    }

    @Override
    public void decode(TLVPrototypeFactory processor, TLVBuffer in) throws EncodingException {
        super.decode(processor, in);
        TLV count = find(NUMBER_OF_EXECUTED_APDUS);
        if (count instanceof RawTLV) {
            byte[] data = ((RawTLV)count).getData();
            apduCount = 0;
            for (int i = 0; i < data.length; i++) {
                apduCount <<= 8;
                apduCount |= data[i] & 0xFF;
            }
        }
        for (TreeNode tlv : childNodes().values()) {
            if (tlv instanceof RAPDUTLV) {
                responses.add(((RAPDUTLV)tlv).getResponse());
            }
        }
    }
}
