/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ResponseHeader extends HeaderTLV {
    /*
     * Status Code
(hexadecimal)
Meaning
'00' PoR OK.
'01' RC/CC/DS failed.
'02' CNTR low.
'03' CNTR high.
'04' CNTR Blocked.
'05' Ciphering error.
'06' Unidentified security error. This code is for the case where the Receiving Entity cannot correctly
interpret the Command Header and the Response Packet is sent unciphered with no RC/CC/DS.
'07' Insufficient memory to process incoming message.
'08' This status code "more time" should be used if the Receiving Entity/Application needs more time
to process the Command Packet due to timing constraints. In this case a later Response Packet
should be returned to the Sending Entity once processing has been completed.
'09' TAR Unknown.
'0A' Insufficient security level.
'0B' Reserved for 3GPP (see TS 31.115 [5]).
     */
    public static final int PoR_OK                      = 0x00;
    public static final int RC_CC_DS_Failed             = 0x01;
    public static final int CNTR_Low                    = 0x02;
    public static final int CNTR_High                   = 0x03;
    public static final int CNTR_Blocked                = 0x04;
    public static final int Ciphering_Error             = 0x05;
    public static final int Undefined_Security_Error    = 0x06;
    public static final int Insufficient_Memory         = 0x07;
    public static final int More_Time                   = 0x08;
    public static final int TAR_Unknown                 = 0x09;
    public static final int Insufficient_Security_Level = 0x0A;

    private int status;

    private TLVBuffer securedDataBuff;

    public int getStatus() {
        return status;
    }

    public int status() {
        return status;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{"
                + "\n    TAR=0x" + Integer.toHexString(0xffffff & getTAR())
                + "\n    CNTR=0x" + Long.toHexString(counter & 0xffffffffffL)
                + "\n    PCNTR=0x" + Integer.toHexString(0xFF & PCNTR)
                + "\n    Status=" + Utils.findName(status, ResponseHeader.class)
                + "\n    RC/CC/DS=0x" + Utils.canonize(checkSum)
                + "}";
    }

    @Override
    public void writeHeaderData(TLVBuffer out) {
        out.write(getTAR(), 3);
        startEncryptedData = out.createPosition();
        out.write(counter, 5);
        out.write(PCNTR);
        out.write(status);
    }

    @Override
    public void parseHeader() throws EncodingException {
        this.headerlength = buffer.read();
        setTAR((int)buffer.read(3)); // TAR
        startEncryptedData = buffer.createPosition();
    }

    public void parseDecryptedHeader() throws EncodingException {
        counter = buffer.read(5); //
//        this.add("CNTR", new Value("CNTR", Integer.toHexString(counter)));
        PCNTR = (byte)buffer.read();
        status = buffer.read();
        int sigLength = headerlength - buffer.getPos() + startValue.pos + 1;
        checkSum = buffer.readArray(sigLength);
        securedDataBuff = buffer.createChild(buffer.available() - PCNTR);
    }

    public TLVBuffer getSecuredData() {
        return securedDataBuff;
    }
}
