/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.R_APDU_TAG;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class RAPDUTLV extends RawTLV {
    ResponseAPDU answer;

    public RAPDUTLV() {
        setTagInternal(R_APDU_TAG, "R-APDU");
    }

    public RAPDUTLV(ResponseAPDU answer) {
        this();
        this.answer = answer;
        data = answer.getBytes();
    }

    public ResponseAPDU getResponse() {
        return answer;
    }

    @Override
    public void decode(TLVPrototypeFactory processor, TLVBuffer in) throws EncodingException  {
        super.decode(processor, in);
        answer = new ResponseAPDU(data);
    }

    @Override
    protected void writeData(TLVBuffer buff) throws Exception {

        super.writeData(buff);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{Tag=" + name + ", " + answer + "}";
    }

}
