/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.CPI_TAG;
import java.util.ArrayList;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class CompactApduPacket extends SecuredPacketTLV {
    public CompactApduPacket() {
        setTagInternal(CPI_TAG, "CommandPacket");
        setCompactMode(true);
    }

    private CommandAPDU[] apdus;

    public CompactApduPacket(CommandAPDU... apdus) {
        this(true, apdus);
    }

    private CompactApduPacket(boolean isCompact, CommandAPDU... apdus) {
        this();
        this.apdus = apdus;
        setCompactMode(isCompact);
    }

    private void addApdu(TLVBuffer out, CommandAPDU apdu, boolean isLast)
            throws EncodingException {
        byte[] data = apdu.getBytes();
            switch (apdu.getCase()) {
            case CASE_1:
                out.write(data);
                out.write(0);
                break;
            case CASE_2S:
                checkLast(isLast);
                out.write(data);
                break;
            case CASE_3S:
                out.write(data);
                break;
            case CASE_4S:
                checkLast(isLast);
                out.write(data, 0, data.length - 1);
                addApdu(out, APDUUtils.createResponseApdu(apdu.getLe()), true);
                break;
            default:
                throw new EncodingException("Unsupported case:" + apdu.getCase());
        }
    }

    @Override
    protected Header createHeader() {
        CommandHeader retVal = new CommandHeader();
        retVal.setTAR(0x000000);
        return retVal;
    }

    private void checkLast(boolean isLast) throws EncodingException {
        if (!isLast) {
            throw new EncodingException("Case 2 or case 4 apdu must the last in the list");
        }
    }

    private static final byte[] empty = new byte[0];

    @Override
    public void decodeSecuredData(TLVPrototypeFactory processor, TLVBuffer securedData) throws EncodingException {
        ArrayList<CommandAPDU> list = new ArrayList<CommandAPDU>();
        while (securedData.available() > 0) {
            byte cla = (byte)securedData.read();
            byte ins = (byte)securedData.read();
            byte p1 = (byte)securedData.read();
            byte p2 = (byte)securedData.read();
            int p3 = securedData.read();
            if (p3 == 0) {
                list.add(new CommandAPDU(cla, ins, p1, p2, empty, (byte)0));
            } else if (securedData.available() > 0) {
                byte[] data = securedData.readArray(p3);
                list.add(new CommandAPDU(cla, ins, p1, p2, data, (byte)0));
            } else {
                list.add(new CommandAPDU(cla, ins, p1, p2, empty, (byte)p3));
            }
        }
        this.apdus = list.toArray(new CommandAPDU[list.size()]);
    }

    @Override
    protected void writeSecuredData(TLVBuffer buff) throws EncodingException {
        for (int i = 0; i < apdus.length; i++) {
            addApdu(buff, apdus[i], i == (apdus.length - 1));//, false);
        }
    }
}
