/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import java.util.ArrayList;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.COMMAND_SCRIPT_TEMPLATE_TAG;
import java.util.List;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class CommandScriptingTemplate extends ConstructedTLV {
    // C-APDU tag 1 '22' '22' or 'A2'

    public CommandScriptingTemplate() {
        setTagInternal(COMMAND_SCRIPT_TEMPLATE_TAG, null);
    }

    public CommandScriptingTemplate(CommandAPDU ... apdus) {
        setTagInternal(COMMAND_SCRIPT_TEMPLATE_TAG, null);
        int count = 0;
        for (CommandAPDU apdu : apdus) {
            add("apdu-" + (++count), new CAPDUTLV(APDUUtils.removeLeIfCase4(apdu)));
            if ((apdu.getLe() > 0) && (apdu.getLc() > 0)) { // Case 4 command
                add("get-response-apdu", new CAPDUTLV(APDUUtils.createResponseApdu(apdu.getLe())));
            }
        }
    }

    public List<CommandAPDU> list() {
        ArrayList<CommandAPDU> retVal = new ArrayList<CommandAPDU>();
        for (TreeNode tlv : childNodes().values()) {
            if (tlv instanceof CAPDUTLV) {
                retVal.add(((CAPDUTLV)tlv).getAPDU());
            }
        }
        return retVal;
    }
}
