/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.CommandAPDU;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class APDUUtils {
    public static final byte GET_RESPONSE_CLA = (byte)0x00;
    public static final byte GET_RESPONSE_INS = (byte)0xC0;

    public static CommandAPDU removeLeIfCase4(CommandAPDU apdu) {
        if ((apdu.getLe() == 0) || (apdu.getLc() == 0)) {
            return apdu;
        }
        byte[] data = apdu.getBytes();
        byte[] modified = new byte[data.length - 1];
        System.arraycopy(data, 0, modified, 0, modified.length);
        return new CommandAPDU(modified);
    }

    public static CommandAPDU createResponseApdu(int le) {
        return new CommandAPDU(new byte[] {
            GET_RESPONSE_CLA, GET_RESPONSE_INS, (byte)0x00, (byte)0x00,
            (byte)le
        });
    }
}
