/*
 * %W% %E% Jonathan Gibbons
 * 
 * Copyright  2002 Sun Microsystems, Inc. All rights reserved. 
 * Use is subject to license terms.
 */

package com.sun.jck.lib;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;

public class JCKTagTestFinder extends TagTestFinder
{
    public JCKTagTestFinder() {
 	addExtension(".jasm", JavaCommentStream.class);
 	addExtension(".jcod", JavaCommentStream.class);
    }

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws Fault {
	if (testSuiteRoot.isDirectory()) {
	    File f = new File(testSuiteRoot, TESTSUITE_HTML);
	    if (!(f.exists() && !f.isDirectory() && f.canRead())) {
		throw new Fault(i18n, "jckFinder.badRootDir", 
				new Object[] {TESTSUITE_HTML, testSuiteRoot.getPath()});
	    }
	}
	else {
	    String name = testSuiteRoot.getName();
	    if (!name.equals(TESTSUITE_HTML)) {
		throw new Fault(i18n, "jckFinder.badRootFile");
	    }
	    // force the test suite root to be the directory
	    testSuiteRoot = new File(testSuiteRoot.getParent());
	}

	super.init(args, testSuiteRoot, env);


    }

    protected int decodeArg(String[] args, int i) throws Fault {
	if (args[i].equals("-verify")) {
	    verify = true;
	    return 1;
	}
	else if (args[i].equals("-allowEntry")) {
	    String e = args[i+1];
	    validEntries.put(e.toLowerCase(), e);
	    return 2;
	}
	else if (args[i].equals("-allowKeyword")) {
	    String k = args[i+1];
	    validKeywords.put(k.toLowerCase(), k);
	    return 2;
	}
	else
	    return super.decodeArg(args, i);
    }

    /**
     * Handle a test description entry read from a file.
     * Valid entries are put in the dictionary; others are ignored.
     * (Note you can specify additional entries to be considered valid, by
     * means of the args to init.) Error messages may optionally be generated
     * if bad entries are found.
     * @param entries   The dictionary of the entries being read
     * @param name	The name of the entry that has been read
     * @param value	The value of the entry that has been read
     */
    protected void processEntry(Map entries, String name, String value) {
	boolean valid = (validEntries.get(name.toLowerCase()) != null);

	if (verify) {
	    if (!valid) {
		error(i18n, "jckFinder.unknownEntry", 
		      new Object[] {name, getCurrentFile()} );
	    }
	    if (name.equalsIgnoreCase("keywords")) {
		String[] keys = StringArray.split(value);
		if (keys != null) {
		    for (int i = 0; i < keys.length; i++) {
			String key = keys[i];
			if (validKeywords.get(key.toLowerCase()) == null) {
			    error(i18n, "jckFinder.unknownKeyword", 
				  new Object[] {key, getCurrentFile()} );
			}
		    }
		}
	    }
	}

	if (valid)
	    super.processEntry(entries, name, value);
    }

    private static Map initTable(String[] entries) {
	Map map = new HashMap();
	for (int i = 0; i < entries.length; i++)
	    map.put(entries[i].toLowerCase(), entries[i]);
	return map;
    }

    private boolean verify;
    private Map validEntries = initTable(JCKTestSuite.getValidEntries());
    private Map validKeywords = initTable(JCKTestSuite.getValidKeywords());

    private static final String TESTSUITE_HTML = "testsuite.html";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTagTestFinder.class);
}
