/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.referenceimpl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;

/**
 * A socket-based interface to Sun's C-JCRE
 * (C language Java Card Runtime Environment).
 * <br>This is an example of a CJCKCardService which a licensee must implement.
 * <em>This code is provided as an example.  Do not assume that this code is totally correct.</em>
 * The {@link CJCKCardService} interface is the definitive specification.
 * <br>The C-JCRE is a Java Card simulator which does simulation at the byte code level.
 *
 * @version Version:1.1	Date:10/20/05
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com)
 */

public class LoadClassFileCardService extends CJCRECardService {
    
    
    /**
     * Creates a new C-JCRE CardService using a socket.
     * This is an example of a CJCKCardService that a licensee would implement.
     * The service cannot be used immediately. The actual initialization
     * is triggered by an invocation of <tt>initialize</tt>.
     */
    public LoadClassFileCardService() {
    }
    
    
    /**
     * Creates a new C-JCRE card service using a socket.
     */
    public LoadClassFileCardService(int port)
        throws java.io.IOException {
        super(port);
    }
    
    
    
    public String convertPackage(String packageName,
            AppletID packageAid,
            int majorVersion,
            int minorVersion,
            String classRootDir,
            String exportRootDir,
            boolean isExportMap,
            String outputDir,
            AppletProperties[] apa)
            throws FrameworkException {
        throw new FrameworkException("Conversion is unsupported");
    }

    /**
     * Loads the specified applets from their class files into the Proxy.
     * This method should be implemented for pre-issuance Products, which
     * support class file format.
     * <br>How the loading is done and where the applets are loaded
     * is at the discretion of the implementer.
     * <P>Note:<ul>
     * <li><em>Only the applet's package name, class name, AID, and params
     * are guaranteed to be valid.</em>
     * <li>Values of other applet properties, such as MAX_STACK, will be -1 if not specified.
     * <li>The implementer should use default values whenever a value of -1 is encountered.
     * </ul>
     * @param packageNames {@link AppletProperties} array with the
     * package names. The array contains names of the all packages,
     * which are required for the test execution.
     * @param appletProperties []an {@link AppletProperties} array
     *     which specifies the applets to be loaded.
     * @param classRootDir the root directory of the class hierarchy.
     * The path /java/lang/javacard is appended to this root,
     * yielding the directory in which the Converter will look for classes.
     * @param outputRootDir the root directory for output.
     * The Export File, if specified, must be put into the directory at
     * the outputRootDir and the path implied by the package name.
     * Any intermediate or other files produced by the Converter
     * must also go into this directory.
     * @exception DeploymentException
     *     if the Proxy is unable to load an applet in the list.
     *     The exception message should be appropriately descriptive.
     */
    public boolean loadClassFileApplets(String[] packages,
            AppletProperties[] apa,
            String classDir,
            String outputDir)
            throws DeploymentException {
        String exportPath = serviceProperties.getProperty("RI") + File.separator 
        + "api_export_files" + File.pathSeparator + outputDir;
        try {
            powerUp();
            for (int i = 0; i < packages.length; i++) {
                AppletProperties[] applets =  getAppletProperties(packages[i], apa);
                String capFile = super.convertPackage(packages[i],
                        getPackageAid(packages[i], applets),
                        0,
                        1,
                        classDir,
                        exportPath,
                        false,
                        outputDir,
                        applets);
                if (capFile == null) {
                    return false;
                }
                if (!super.installCAPFile(((i == (packages.length - 1)) ? apa : new AppletProperties[0]),
                        capFile, outputDir)) {
                    return false;
                }
            }
            return true;
        } catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
    }

    private AppletProperties[] getAppletProperties(String packName,
                                                   AppletProperties[] applets)
        throws DeploymentException {
        ArrayList retVal = new ArrayList();
        for (int i = 0; i < applets.length; i++) {
            if (applets[i].getPackageName().equals(packName)) {
                retVal.add(applets[i]);
            }
        }
        return (AppletProperties[])retVal.toArray(new AppletProperties[retVal.size()]);
    }
    long packageCount = new Random().nextInt();
    byte[] defaultRID = new byte[] {
            (byte)0xA0, (byte)0x02, (byte)0x00, (byte)0x00, (byte)0x62, // Sun's RID
            (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
            (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00
    };

    private AppletID getPackageAid(String packName, AppletProperties[] applets) 
    throws DeploymentException {
        byte[] retVal = new byte[13];
        byte[] rid = ((applets == null) || (applets.length == 0)) 
        ? defaultRID : applets[0].getAID().getBytes();
        for (int i = 0 ; i < 5; i++) {
            retVal[i] = rid[i];
        }
        do {
            long count = packageCount++;
            for (int i = 5; i < 13; i++) {
                retVal[i] = (byte)count;
                count = count >> 8;
            }
        } while (isIncluded(retVal, applets));
        StringBuffer message = new StringBuffer("Created package AID for package:");
        message.append(packName);
        message.append(" -");
        for (int i = 0; i < retVal.length; i++) {
            message.append(" 0x");
            message.append(Integer.toHexString(0xFF & retVal[i]));
        }
        log.log(message.toString(), Logger.MESSAGE);
        return new AppletID(retVal);
    }

    private boolean isIncluded(byte[] retVal, AppletProperties[] applets) {
        if (applets == null) {
            return false;
        }
        for (int i = 0; i < applets.length; i++) {
            if (equals(retVal, applets[i].getAID().getBytes())) {
                return true;
            }
        }
        return false;
    }
    
    private static boolean equals(byte[] left, byte[] right) {
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; i++) {
            if (left[i] != right[i]) {
                return false;
            }
        }
        return true;
    }


    /**
     * Loads the specified applets from their cap files into the Proxy.
     * This method should be implemented for pre-issuance Products, which
     * support CAP file format.
     * <br>How the loading is done and where the applets are loaded
     * is at the discretion of the implementer.
     * <P>Note:<ul>
     * <li><em>Only the applet's package name, class name, AID, and params
     * are guaranteed to be valid.</em>
     * <li>Values of other applet properties, such as MAX_STACK, will be -1 if not specified.
     * <li>The implementer should use default values whenever a value of -1 is encountered.
     * </ul>
     * @param capfiles {@link AppletProperties} array with the
     * cap file names. The array contains names of the all cap files,
     * which are required for the test execution.
     * @param appletProperties []an {@link AppletProperties} array
     *     which specifies the applets to be loaded.
     * @param outputRootDir the root directory for output.
     * The Export File, if specified, must be put into the directory at
     * the outputRootDir and the path implied by the package name.
     * Any intermediate or other files produced by the Converter
     * must also go into this directory.
     * @exception DeploymentException
     *     if the Proxy is unable to load an applet in the list.
     *     The exception message should be appropriately descriptive.
     */
    public boolean loadCapFileApplets(String[] capfiles,
            AppletProperties[] apa,
            String outputDir)
            throws DeploymentException {
        throw new DeploymentException("Loading of the cap files is unsupported");
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray,
            String aCAPFileName,
            String outputDir)
            throws DeploymentException {
        throw new DeploymentException("Installation is unsupported.");
    }
}
