/*
 * $Id$
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.tck.bvtool.etsi.gp.GPCapFileInfo;
import com.sun.tck.me.utils.Utils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;

/**
 *
 * @author ms106086
 */
public class DebugCJCRECardService extends CJCRECardService {

    private LinkedHashSet<String> packages = new LinkedHashSet<String>();
    private PrintWriter out;

    @Override
    public boolean deletePackage(AppletID packageID, String packageName) throws DeploymentException {
        boolean retVal = super.deletePackage(packageID, packageName);
        if (retVal) {
            packages.remove(canonize(packageID.getBytes()));
        }
        return retVal;
    }

    @Override
    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws DeploymentException {
        boolean retVal = super.deletePackageAndInstances(packageID, packageName);
        if (retVal) {
            packages.remove(canonize(packageID.getBytes()));
        }
        return retVal;
    }

    @Override
    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws DeploymentException {
        boolean retVal = super.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
        try {
            if (retVal) {
                GPCapFileInfo info = GPCapFileInfo.createData(out, aCAPFileName);
                packages.add(canonize(info.packageAID.getBytes()));
            }
        } catch (Exception e) {
            out.println("DEBUG-ERROR:" + e);
            e.printStackTrace(out);
        }
        return retVal;
    }
    public static String canonize(byte[] path) {
        if (path == null) {
            return null;
        }
        return canonize(path, 0, path.length);
    }

    public static String canonize(byte[] path, int offset, int length) {
        if (path == null) {
            return null;
        }
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < length; i++) {
            String e =  Integer.toHexString(path[i + offset] & 0xFF);
            if (e.length() == 1) {
                retVal.append('0');
            }
            retVal.append(e);
        }
        return retVal.toString();
    }

    @Override
    public void stopTest() throws FrameworkException {
        ArrayList<String> aids = new ArrayList<String>();
        aids.addAll(packages);
        powerUp();
        for (int i = aids.size() - 1; i >= 0; i--) {
            String aid = aids.get(i);
            out.println("DEBUG-LOG: deleting " + aid);
            try {
                AppletID id = new AppletID(Utils.parse(aid));
                boolean retVal = deletePackageAndInstances(id, "unknown");
                if (retVal) {
                    out.println("DEBUG-LOG:OK " + aid);
                } else {
                    out.println("DEBUG-ERROR:FAILS " + aid);
                }
            } catch (Exception e) {
                out.println("DEBUG-ERROR:" + e);
                e.printStackTrace(out);
            }
        }
        powerDown();
        super.stopTest();
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        super.init(args, out, ref);
        this.out = out;
    }

    @Override
    public void startTest(String workingDir, int numberOfExecutions) throws FrameworkException {
        super.startTest(workingDir, numberOfExecutions);
    }

}
