/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.*;
import java.io.*;
import com.sun.javacard.referenceimpl.ProcessManager.Descriptor;
import com.sun.javacard.apduio.TLP224Exception;



/**
 *
 * @author Dmitri Trounine
 */
public class ContactlessService extends CJCRECardService {
    protected CJCRECardService contactedService;

    void setContactedService(CJCRECardService service) {
        contactedService = service;
    }

    public boolean isCrefRunning() {
        if (contactedService != null) {
            return contactedService.isCrefRunning();
        } else {
            return super.isCrefRunning();
        }
    }

    int getPort() {
        return contactedService.getPort() + 1;
    }
    
    public void startCref() throws FrameworkException {
        super.startCref();
        if (contactedService != null) {
            contactedService.crefRunning = true;
        }
    }

    public void powerDownCad()  throws TLP224Exception, IOException {
        log.log("powerDownCad()", Logger.DEBUG_TRACE);
        cad.powerDown();
    }

    public void stopCref() {
    }
    

    public Descriptor getCurrentProcDescriptor() {
        if (currentProcDescriptor == null) {
            if (contactedService != null) {
                currentProcDescriptor = contactedService.getCurrentProcDescriptor();
            }
        }
        return currentProcDescriptor;
    }


    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        super.init(args, out, ref);
        log = new PrefixLogger("CONTACTLESS: ", 0, out, ref);
    }

    public void powerUp() throws FrameworkException {
        log.log("powerUp()", Logger.DEBUG_TRACE);
        if (isMainCommunicationService) {
            log.log("Call contacted service powerUp from contactless service", Logger.DEBUG_TRACE);
            contactedService.powerUp();
        }
        initiateContacted();
        super.powerUp();
    }
    
    public void powerDown() throws FrameworkException {
        super.powerDown();
        if (isMainCommunicationService) {
            contactedService.powerDown();
        }
    }

    protected void initiateContacted() throws FrameworkException {
        CommandAPDU openChCmd = new CommandAPDU((byte)0x00, (byte)0x70, (byte)0x00, (byte)0x01, new byte[] {}, 0);
        CommandAPDU closeChCmd = new CommandAPDU((byte)0x00, (byte)0x70, (byte)0x80, (byte)0x01, new byte[] {}, 0);
        contactedService.sendAPDU(openChCmd);
        contactedService.sendAPDU(closeChCmd);
    }
}

class PrefixLogger extends Logger {
    private String prefix = "";

    public PrefixLogger(String prefix, int level, PrintWriter out, PrintWriter ref) {
        super(level, out, ref);
        this.prefix = prefix;
    }

    public void log(String msg, int debug_level) {
        super.log(prefix + msg, debug_level);
    }

    public void err(String msg, int debug_level) {
        super.err(prefix + msg, debug_level);
    }
}
