/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;

/**
 *
 * @author ms106086
 */
public class FatalException extends CardProxyException {
    public static enum Scope {
        Card,
        Test,
        CAD,
        CAD_SYSTEM;
    }

    public void filter(Scope... scopes) throws FatalException {
        for (Scope scope : scopes) {
            if (this.scope == scope) {
                return;
            }
        }
        throw this;
    }

    private Scope scope;

    public FatalException(Scope scope, String s) {
        super(s);
        this.scope = scope;
    }

    public FatalException(Scope scope, String message, Throwable cause) {
        super(message, cause);
        this.scope = scope;
    }
}
