/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.userinterface;

/**
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com), Dmitri Trounine
 */
public interface CommunicationService {
    
    /////////////////////////////////////////////////////////////////////////////
    // Control functions
    /////////////////////////////////////////////////////////////////////////////
    
    /**
     * Power-up the Proxy. If the Proxy has already been powered-up, this
     * method does nothing.
     * @see CJCKCardService#loadClassFileApplets
     * @see CJCKCardService#installCAPFile
     * @exception CardProxyException
     *     Thrown if powerUp failed.
     */
    public void powerUp() throws CardProxyException;
    
    
    /**
     * Power-down the Proxy. If the Proxy has already been powered-down, this
     * method do nothing.
     * @exception CardProxyException
     *     Thrown if powerDown failed.
     */
    public void powerDown() throws CardProxyException;
    
    /**
     * Reset the Proxy.  Equivalent to resetting a smart card using the RESET line.
     * @exception CardProxyException
     *     Thrown if reset failed.
     */
    public void reset() throws CardProxyException;
    
    
    /////////////////////////////////////////////////////////////////////////////
    // I/O functions
    /////////////////////////////////////////////////////////////////////////////
    
    /**
     * Sends a <tt>CommandAPDU</tt> to the Proxy and gets the <tt>ResponseAPDU</tt>.
     * <br>Note:<ul>
     * The Card Service must copy the <tt>CommandAPDU</tt> bytes into the
     * <tt>ResponseAPDU</tt>.
     * </ul>
     * @param capdu
     *     The <tt>CommandAPDU</tt> to send.
     * @exception CardProxyException
     *     if sendAPDU failed.
     */
    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardProxyException;
    
}
