/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.I18n;
/**
 *
 * @author Dmitri Trounine
 */
public class CardServiceFactory {
     /////////////////////////////////////////////////////////////////////////////
    // Named constants
    /////////////////////////////////////////////////////////////////////////////
   
   
    /**
     * The major version of this class, currently 1.
     */
    public final static int MAJOR_VERSION =    1;

    /**
     * The minor version of this class, currently 0.
     */
    public final static int MINOR_VERSION =    0;

    /**
     * The default CardService class.
     */
    public final static String DEFAULT_CARD_SERVICE = "CJCKCardService";


    /**
     * Creates new CardServiceFactory.
     * @exception CardProxyException
     * thrown if unable to create a new CardServiceFactory.
     */
    public CardServiceFactory()
        throws CardProxyException {
                        
        }

    /**
     * Gets the default CardProxy.
     * @return the default CardProxy.
     * @exception CardProxyException
     * Thrown if unable to get the default CardProxy.
     */
    public static CardService getCardService()
        throws CardProxyException {
            return getCardService(DEFAULT_CARD_SERVICE);
            
        }


    /**
     * Gets the CardProxy specified by its proxy name and class loader.
     * @param proxyClassName the class name of the CJCKCardProxy.
     * @param loader the Class loader.
     * @return the CardProxy with the given proxy name and class loader.
     * @exception CardProxyException
     * thrown if unable to get the CardProxy with the given proxy name and 
     * class loader.
     */
    public static CardService getCardService(String proxyClassName,
                                                     ClassLoader loader)
        throws CardProxyException {
        Object cs = null;
          try    {
            cs = Class.forName(proxyClassName, true, loader).newInstance();
            return (CardService) cs;
        } catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
    }
      
    /**
     * Gets the CardProxy specified by its class name.
     * @param proxyClassName the class name of the CardProxy.
     * @return CardProxy with the given proxy class name.
     * @exception CardProxyException
     * thrown if unable to get the CardProxy with the given proxy class name.
     */
    public static CardService getCardService(String proxyClassName)
        throws CardProxyException {
        CardService ccs;
        try {
            ccs = (CardService)Class.forName(proxyClassName).newInstance();
        } catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
        return ccs;
    }
  
}
