/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;

/**
 * The interface for all cJCK card services.
 * Each licensee is expected to implement a CardService class
 * which implements this interface.
 * <P>Overview.
 * The cJCK will:<ul>
 *   <li>instantiate the licensee's CardService class</li>
 *   <li>initialize the CardService class by configuration Properties.
 *       The cJCK does not apply any constrains on these properties.
 *       Licensee can define properties on your .</li>
 *   <li>signal that a test is starting by calling <code>startTest</code></li>
 *   <li>load applets into the Proxy using 
 *       <code>loadClassFileApplets</code> or <code>loadCapFileApplets</code>
 *   <li>call <code>powerUp</code> to start the Proxy</li>
 *   <li><code>installCAPFile</code> into the Proxy</li>
 *   <li>do I/O using <code>sendAPDU</code></li>
 *   <li>call <code>powerDown</code> to power down card,</li>
 *   <li>signal that the test is stopping by calling <code>stopTest</code></li>
 * </ul>
 * <br>Note:<ul>
 * <li>The cJCK does not timeout any operation.
 * If a method hangs, the cJCK will hang.
 * It is the responsibility of the implementor of the CardService class
 * to timeout all operations.
 * <li>The CardService class' constructor is not required to do anything.
 * </ul>
 *
 * @version Version:1.20 Date:11/21/05
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com), Dmitri Trounine
 */
public interface CJCKCardService extends CardService, CommunicationService {
    /////////////////////////////////////////////////////////////////////////////
    // Named constants
    /////////////////////////////////////////////////////////////////////////////

    /**
     * The release version of the CJCKCardService class, currently "2.2.1".
     */
    public final static String RELEASE_VERSION = "2.2.1";

    /**
     * The build version of the CJCKCardService class, currently Version: 1.20.
     */
    public final static String BUILD_VERSION = "Version:1.20";

    /**
     * The build date of the CJCKCardService class, currently Date: 11/21/05.
     */
    public final static String BUILD_DATE = "Date:11/21/05";

    /**
     * The major version of the CJCKCardService class, currently 2.
     */
    public final static int MAJOR_VERSION = 2;

    /**
     * The minor version of the CJCKCardService class, currently 2.
     */
    public final static int MINOR_VERSION = 2;

}
