/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;
import com.sun.javacard.cjck.I18n;


public class AppletID {

    /**
     * Contains bytes of the AppletID. The AppletID should comply with ISO7816 standard.
     */ 
    protected byte[] data;
    

    /**
     * Creates AppletID with the given bytes.  The bytes should comply with ISO7816 standard.
     * @param data byte array containing the AppletID bytes.
     */ 
    public AppletID(byte[] data) {
        this.data = data;
    }

    /**
     * Gets all the AppletID bytes.
     * @return byte array containing the AppletID.
     */
    public byte[] getBytes() {
        return data;
    }

    /**
     * Compares the AppletID bytes in this AppletID instance to the 
     * AppletID bytes in the specified object.
     * @param o the object to compare this AppletID against. 
     * @return true if the AppletID byte values are equal, false otherwise. 
     */
    public boolean equals(Object o) {
        if (o instanceof AppletID) {
            byte[] current = getBytes();
            byte[] data = ((AppletID)o).getBytes();
            if (data.length != current.length) {
                return false;
            } else {
                for (int i = 0; i < data.length; i++) {
                    if (data[i] != current[i]) {
                        return false;
                    }
                }
                return true;
            }
        } else {
            return false;
        }
    }

    /**
     * Gets the string representation of this AppletID.
     * @return string representation of this AppletID.
     */
    public String toString() {
        byte[] data = getBytes();
        if (data.length == 0) {
            return I18n.getString("empty.aid");
        }
        
        StringBuffer buff = new StringBuffer("(AID = 0x");
        buff.append(Integer.toHexString(data[0] & 0xFF));
        for (int i = 1; i < data.length; i++) {
            buff.append(":0x");
            buff.append(Integer.toHexString(data[i] & 0xFF));
        }
        
        buff.append(")");
        return buff.toString();
    }
}
