/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;


public class APDU {

    /**
     * Contains bytes of the APDU. The bytes should comply with ISO7816 standard.
     */
    public byte[] data;

    /**
     * Creates APDU with the given bytes. The bytes should comply with ISO7816 standard.
     * @param data byte array containing the APDU bytes.
     */
    public APDU(byte[] data) {
        this.data = data;
    }
    protected APDU() {
    }

    /**
     * Gets all the APDU bytes.
     * @return byte array containing the APDU bytes.
     */
    public byte[] getBytes() {
        return data;
    }

    /**
     * Gets the length of the APDU bytes.
     * @return the length of the APDU bytes.
     */   
    public int getLength() {
        return (data == null) ? 0 : data.length;
    }

    protected String byteToHexDigits(int b) {
        String retVal = Integer.toHexString(0xFF & b);
        return (retVal.length() == 2) ? retVal : "0" + retVal;
    }
    protected String byteToHex(int b) {
        String retVal = Integer.toHexString(0xFF & b);
        return (retVal.length() == 2) ? "0x" + retVal : "0x0" + retVal;
    }
}
