/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts.rmi;

import java.io.PrintWriter;
import java.util.Enumeration;

import com.sun.javatest.Status;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.I18n;

public class RemoteRefWithClass extends RemoteRef {
    private String package_name;
    private String name;
    
    public RemoteRefWithClass(int id, String hash, String pack, String name) {
        super(id, REF_WITH_CLASS, hash);
        this.package_name = pack;
        this.name = name;
    }
    
    public String getPackageName() {
        return package_name;
    }
    
    public String getClassName() {
        return name;
    }

    public String toString() {
        return I18n.getString("remoterefwithclass.info", new Object[] {
                               Integer.toHexString(getRefID()), getHashModifier(), 
			       getPackageName(), getClassName()});
    }
}

