/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.StringTokenizer;

import com.sun.javatest.Status;

import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.CustomizableScript;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.cjck.I18n;


public class ResourceScript extends StdScript implements CustomizableScript {
    
    public static final int MAX_RESOURCE = 0x7FFF;
    public static final short SW_TEST_PASSED = (short)0x9B00;
    private static final int CHUNK_SIZE = 32;
    
    private final static byte CLA_JCRE_TEST = (byte)0x80;

    private final static byte INS_DO_TESTS  = (byte)0x20;
    private final static byte INS_DATA_TO_CARD = (byte)0x40;
    private final static byte INS_DATA_FROM_CARD = (byte)0x30;

    private final static byte START = (byte)0x01;
    private final static byte PROGRESS = (byte)0x02;
    private final static byte END = (byte)0x04;

    private String fileName;
    private String goldenFileName;
    private CardProxyArguments args;


    public Status sendResourceToCard(InputStream in, byte id)
        throws ScriptFailException, CardProxyException {
        byte data[];
        try {
            data = loadData(in);
        } catch (IOException e) {
            e.printStackTrace();
            return Status.error(I18n.getString("can.not.load.resource"));
        }
        sendAPDU(new CommandAPDU(new byte[] {
            CLA_JCRE_TEST, INS_DATA_TO_CARD, START, (byte)0x00, (byte)0x02,
            (byte)(data.length >> 8), (byte)(data.length & 0xFF), (byte)0x7F
        }), SW_TEST_PASSED);
        
        for (int offset = 0; offset < data.length;) {
            int len = data.length - offset;
            len = (len > CHUNK_SIZE) ? CHUNK_SIZE : len;
            byte[] sent = new byte[len + 5];
            sent[0] = CLA_JCRE_TEST;
            sent[1] = INS_DATA_TO_CARD;
            sent[2] = PROGRESS;
            sent[3] = (byte)0x00;
            sent[4] = (byte)len;
            System.arraycopy(data, offset, sent, 5, len);
//            sent[sent.length - 1] = (byte)0x7F;
            sendAPDU(new CommandAPDU(sent), SW_TEST_PASSED);
            offset += len;
        }
        sendAPDU(new CommandAPDU(new byte[] { CLA_JCRE_TEST, INS_DATA_TO_CARD,
                                              END, (byte)id }),
                 SW_TEST_PASSED);
        return Status.passed("");
    }

    
    public byte[] receiveResourceFromCard(byte id)
        throws ScriptFailException, CardProxyException {
        CommandAPDU apdu = new CommandAPDU(new byte[] { CLA_JCRE_TEST,
                                                        INS_DATA_FROM_CARD,
                                                        START, id, (byte)2});
        ResponseAPDU answer = sendAPDU(apdu);
        byte[] resp = answer.getBytes();
        if ((answer.sw() != (SW_TEST_PASSED & 0xFFFF)) || (resp.length != 4)) {
            log(I18n.getString("receive.resource.from.card.answer", Integer.toHexString(answer.sw())));
            log(I18n.getString("receive.resource.from.card.res.length", Integer.toHexString(resp.length)));
            
            throw new ScriptFailException(I18n.getString("error.communication"));
        }
        byte[] data = new byte[((resp[0] << 8) & 0xFF00) | (resp[1] & 0xFF)];
        for (int offset = 0; offset < data.length;) {
            apdu = new CommandAPDU(new byte[] {CLA_JCRE_TEST,
                                               INS_DATA_FROM_CARD,
                                               PROGRESS, (byte)0, (byte)0x7F});
            
            answer = sendAPDU(apdu);
            resp = answer.getBytes();
            int len = resp.length - 2;

            if ((answer.sw() != (SW_TEST_PASSED & 0xFFFF))
                || (offset + len > data.length)) {
                throw new ScriptFailException(I18n.getString("error.communication"));
            }
            
            System.arraycopy(resp, 0, data, offset, len);
            offset += len;
        }
        sendAPDU(new CommandAPDU(new byte[] { CLA_JCRE_TEST, INS_DATA_FROM_CARD,
                                              END, (byte)id }),
                 SW_TEST_PASSED);
        return data;
    }

    /**
     * loads data from file. The data are specified in the file as
     * sequence of the hexadecimal constants (for example 0x01,
     * 0xFF). The comments are started from // and ended by the end of
     * the line.
     */
    protected byte[] loadData(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buff = new StringBuffer();
        String line;
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf("//");
            if (pos >= 0 ) {
                line = line.substring(0, pos);
            }
            buff.append("\n");
            buff.append(line);
        }

        StringTokenizer bytes = new StringTokenizer(buff.toString(), "\n\t ");
        
        int length = bytes.countTokens();
        if (length > MAX_RESOURCE) {
            throw new IllegalArgumentException(I18n.getString("invalid.length", 
                                               Integer.toHexString(MAX_RESOURCE)));
        }
        byte[] data = new byte[length];
        for (int i = 0; i < data.length; i++) {
            String token = bytes.nextToken();
            if ((token.charAt(0) != '0') &&
                ((token.charAt(1) != 'x') || (token.charAt(1) != 'X'))) {
                throw new ScriptFailException(Status.error(I18n.getString("incorrect.format", token)));
            }
   
            data[i] = (byte)Integer.parseInt(token.substring(2), 16);
        }
        return data;
    }
    
    public void setArguments(String args[]) {
        for (int i = 0; i < (args.length - 1)  ; i++) {
            if (args[i].equalsIgnoreCase("-in")) {
                fileName = args[++i];
            } else if (args[i].equalsIgnoreCase("-out")) {
                goldenFileName = args[++i];
            }
        }
    }

    public Status runScript() throws CardProxyException {
        try {
            select(args.getExecuteClass());
            FileInputStream in = new FileInputStream(new File(args.getTestDir(),
                                                              fileName));
            FileInputStream out = new FileInputStream(new File(args.getTestDir(),
                                                               goldenFileName));
            Status status = sendResourceToCard(in, (byte)0);
            
            if (!status.isPassed()) {
                return status;
            }
            byte[] result = receiveResourceFromCard((byte)0);
            byte[] golden = loadData(out);
            if (result.length != golden.length) {
                log(I18n.getString("incorrect.return.length", Integer.toHexString(golden.length), 
                                   Integer.toHexString(result.length)));
                return Status.failed(I18n.getString("incorrect.return.length.1"));
            }
            status = Status.passed("");
            for (int i = 0; i < result.length; i++) {
                if (result[i] != golden[i]) {
                    log(I18n.getString("incorrect.result",  Integer.toHexString(i), 
                        new Byte(golden[i]), new Byte(result[i])));
                    status = Status.failed(I18n.getString("incorrect.result.1", Integer.toHexString(i)));
                }
            }
            return status;
        } catch (Exception e) {
            e.printStackTrace();
            return Status.error(e.toString());
        }
    }

    /**
     * compares result array with expected array. This method throws
     * <code>ScriptFailException</code> if there is at least one byte
     * which is differ in the result and expected.
     */
    public void compareResults(byte[] result, int resultOffset,
                                      byte[] expected, int expectedOffset,
                                      int length) {
        if (((resultOffset + length) > result.length)
            || ((expectedOffset + length) > expected.length)) {
            throw new ScriptFailException(I18n.getString("inconsistent.length"));
        }
        
        Status status = Status.passed("");
        for (int i = 0; i < length; i++) {
            if (result[resultOffset + i] != expected[expectedOffset + i]) {
                log(I18n.getString("incorrect.result", Integer.toHexString(resultOffset + i), 
                                    new Byte(expected[expectedOffset + i]), 
                                    new Byte(result[resultOffset + i])));
                status = Status.failed(I18n.getString("incorrect.result.1", 
                                       Integer.toHexString(resultOffset + i)));
            }
        }
        if (!status.isPassed()) {
            throw new ScriptFailException(status);
        }
    }

    /**
     * compares result array with array loaded from the golden
     * file. This method throws <code>ScriptFailException</code> if
     * there is at least one byte which is differ in the result array and
     * golden file.
     */
    public void compareResults(byte[] result, int resultOffset, int length,
                               String goldenFileName) throws IOException {
        byte[] expec = loadData(new FileInputStream(new File(args.getTestDir(),
                                                             goldenFileName)));
        compareResults(result, resultOffset, expec, 0, length);
    }

    /**
     * compares result array with array loaded from the golden
     * file. This method throws <code>ScriptFailException</code> if
     * there is at least one byte which is differ in the result array
     * and golden file or the lengths of the result array and array
     * loaded from the golden file are differ.
     */
    public void compareResults(byte[] result, String goldenFileName)
        throws IOException {
        byte[] data = loadData(new FileInputStream(new File(args.getTestDir(),
                                                            goldenFileName)));
        if (data.length != result.length) {
            throw new ScriptFailException(I18n.getString("incorrect.length", 
                                          Integer.toHexString(result.length), 
                                          Integer.toHexString(data.length)));
        }
        compareResults(result, 0, result.length, goldenFileName);
    }
        
    public void setCardProxyArguments(CardProxyArguments arguments) {
        this.args = arguments;
    }
}
