/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

import com.sun.javatest.Status;

import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.CardProxyTest;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.invoke.CustomizableScript;
import com.sun.javacard.cjck.invoke.MultiTestScript;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.cjck.I18n;


public abstract class MultiStdScript extends StdScript
    implements MultiTestScript {
    
    public static final short SW_SELECT_PASSED  = (short)0x9000;
    
    protected String[] cases;


    public abstract Status runTestCase(int id, String name)
        throws CardProxyException;
    
    public int getTestCaseCount() {
        return (this.cases == null) ? 0 : this.cases.length;
    }

    public MultiStdScript(String[] cases) {
        this.cases = cases;
    }

    public Status runScript() throws CardProxyException {
        Status retVal = Status.passed("");
        for (int id = 1; id <= getTestCaseCount(); id++) {
            String name = this.cases[id - 1];
            if (checkTestCase(name)) {
                Status current;
                try {
                    log(I18n.getString("start.testcase", name));
                    current = runTestCase(id, cardService, out, ref);
                } catch (ScriptFailException e) {
                    current = e.getStatus();
                }
                log(I18n.getString("testcase.id", new Integer(id), current));
                retVal = current.isPassed() ? retVal : current;
            }
        }

        return retVal;
    }

    protected void startTestCase() throws CardProxyException {
        select(args.getExecuteClass(), SW_SELECT_PASSED);
    }
    
    public Status runTestCase(int index, CJCKCardService cardService,
                              PrintWriter out, PrintWriter ref)
        throws CardProxyException {
        init(cardService, out, ref);

        String name = this.cases[index - 1];
        if (!checkTestCase(name)) {
            return Status.passed(I18n.getString("test.been.excluded"));
        }
        cardService.powerUp();
        try {
            startTestCase();
            
            Status current;
            try {
                log(I18n.getString("start.testcase", name));
                current = runTestCase(index, name);
            } catch (ScriptFailException e) {
                current = e.getStatus();
            }
            log(I18n.getString("testcase.id", Integer.toHexString(index), current));
            return current;
        } finally {
            cardService.powerDown();
        }
    }
}
