/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.I18n;

public class Channel {
    private int id;
    private short sw_status;
    private ResponseAPDU apdu;

    public Channel(int id, ResponseAPDU apdu) {
        this.id = id;
        this.apdu = apdu;
        this.sw_status = (short)apdu.sw();
    }

    /**
     * returns the number of the channel, which is tried to be
     * opened. This method does not guarantee that this channel really
     * opened.
     */ 
    public int getChannelNumber() {
        return id;
    }

    /**
     * returns SW status of APDU, which opens this channel.
     */
    public short getSWStatus() {
        return sw_status;
    }

    /**
     * creates APDU command assigned for the current channel.
     */
    public CommandAPDU createAPDUtoChannel(byte[] data) {
        if (id < 0) throw new IllegalArgumentException(I18n.getString("channel.not.open"));
        int cla = (data[0] & 0xF0);
        if ((cla != 0x00) &&  (cla != 0x80) && (cla != 0x90) && (cla != 0xA0)) {
            throw new IllegalArgumentException(I18n.getString("incorrect.cla"));
        }
        data[0] = (byte)(data[0] | (id & 3));
        return new CommandAPDU(data);
    }

    /**
     * returns ResponseAPDU, which opens this channel.
     */
    public ResponseAPDU getApdu() {
        return this.apdu;
    }

    public String toString() {
        return I18n.getString("channel.number", new Integer(getChannelNumber()), 
                               Integer.toHexString(getSWStatus() & 0xFFFF));
    }

};
