/*
 * %W% %E%
 *
 * @Copyright
 */
package com.sun.javacard.cjck.invoke;

import java.io.File;
import java.util.Date;

import com.sun.javacard.cjck.I18n;

public class Utils {
    /**
     * Return a String which describes the file.
     * @param fileName a fully qualified file name
     */
    public static String fileInfo(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        Date lastModDate = new Date(f.lastModified());
        String info = I18n.getString("file.info", fileName, Long.toString(f.length()), lastModDate);
        return info;
    }
      

    public static String getCanonicalName(String dir, String name) {
        return dir + File.separator + name.replace('/', File.separatorChar);
    }

}
