/*
 * %W% %E%
 *
 * @Copyright
 */
package com.sun.javacard.cjck.invoke;

import java.io.PrintWriter;

import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;

/**
 * The basic class for all modes.
 */
public abstract class RunMode {
    protected PrintWriter logWriter;
    protected PrintWriter refWriter;
    protected CJCKCardService cardService;
    
    /**
     * Initializes mode prior using. his methid is invoked prior prior other
     * method of the class are invoked. 
     */
    public void init(PrintWriter log, PrintWriter ref, CJCKCardService cardService) {
        this.logWriter = log;
        this.refWriter = ref;
        this.cardService = cardService;
    }
    
    /**
     * Executes the 
     * @param configFile
     * @return
     * @throws CardProxyException
     */
    public abstract Status run(CardProxyArguments args, ConfigFileReader configFile) 
        throws CardProxyException;
    public abstract String getName();
    
    protected void log(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    protected void ref(Object o) {
        log(o);
        if (this.refWriter != null) {
            this.refWriter.println(o);
        }
    }
}
